package cn.com.anysdk.oss.config;

import cn.com.anysdk.oss.api.IOssConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class TencentCloudOssConfig implements IOssConfig {
    private final String endpoint;
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String bucketName;
    private final boolean isPrivate;
    private final boolean isIntranet;
    private final String customDomain;

    public COSClient createCosClient() {
        COSCredentials cred = new BasicCOSCredentials(accessKeyId, accessKeySecret);
        ClientConfig clientConfig = new ClientConfig(new Region(endpoint));
        return new COSClient(cred,clientConfig);
    }



    @Override
    public String getAccessKeyId() {
        return accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    @Override
    public String getBucketName() {
        return bucketName;
    }

    @Override
    public String getEndpoint() {
        return endpoint;
    }

    @Override
    public boolean isIntranet() {
        return isIntranet;
    }

    @Override
    public String getCustomDomain() {
        return customDomain;
    }

    @Override
    public boolean isPrivateMode() {
        return isPrivate;
    }

    @Override
    public String getProvider() {
        return "tencent";
    }

    }
