package cn.com.anysdk.oss.monitor;

import lombok.Builder;
import lombok.Data;

import java.util.Map;

/**
 * OSS操作上下文
 * 包含操作相关的上下文信息
 */
@Data
@Builder
public class OssOperationContext {
    /**
     * 操作类型
     */
    private OperationType operationType;

    /**
     * 存储提供商
     */
    private Provider provider;

    /**
     * 文件路径
     */
    private String path;

    /**
     * 操作耗时（毫秒）
     */
    private long duration;

    /**
     * 文件大小（字节）
     */
    private long fileSize;

    /**
     * 是否私有访问
     */
    private boolean isPrivate;

    /**
     * 请求ID
     */
    private String requestId;

    /**
     * 额外信息
     */
    private Map<String, Object> extraInfo;

    /**
     * 操作类型枚举
     */
    public enum OperationType {
        UPLOAD,
        DOWNLOAD,
        DELETE,
        GET_URL,
        GET_SIGNED_URL,
        CHECK_EXIST
    }

    /**
     * 存储提供商枚举
     */
    public enum Provider {
        ALIYUN,
        TENCENT,
        QINIU,
        LOCAL
    }
}