package cn.com.anysdk.oss.monitor.impl;

import cn.com.anysdk.oss.api.OssExceptionListener;
import cn.com.anysdk.oss.exception.OssException;
import cn.com.anysdk.oss.monitor.OssOperationContext;
import lombok.extern.slf4j.Slf4j;

/**
 * 日志异常监听器
 * 将异常信息记录到日志中
 */
@Slf4j
public class LoggingExceptionListener implements OssExceptionListener {

    @Override
    public void onException(OssException exception, OssOperationContext context) {
        log.error("OSS operation failed - Provider: {}, Operation: {}, Error: {}",
                context.getProvider(),
                context.getOperationType(),
                exception.getMessage(),
                exception);
    }
}