/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.api;

public class UploadOptions {
    private boolean isPrivate;
    private Long expireTime;
    private String contentType;
    private String acl;
    private Long maxSize;
    private boolean useMultipart;
    private long partSize = 0x500000L;

    public static UploadOptions publicFile() {
        return new UploadOptions().setPrivate(false).setUseMultipart(false);
    }

    public static UploadOptions privateFile(Long expireTime) {
        return new UploadOptions().setPrivate(true).setExpireTime(expireTime).setUseMultipart(false);
    }

    public static UploadOptions largeFile(boolean isPrivate, long partSize) {
        return new UploadOptions().setPrivate(isPrivate).setUseMultipart(true).setPartSize(partSize);
    }

    public static UploadOptions withContentType(String contentType, boolean isPrivate) {
        return new UploadOptions().setPrivate(isPrivate).setContentType(contentType).setUseMultipart(false);
    }

    public static UploadOptions withAcl(String acl, boolean isPrivate) {
        return new UploadOptions().setPrivate(isPrivate).setAcl(acl).setUseMultipart(false);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public Long getExpireTime() {
        return this.expireTime;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getAcl() {
        return this.acl;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public boolean isUseMultipart() {
        return this.useMultipart;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public UploadOptions setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        return this;
    }

    public UploadOptions setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    public UploadOptions setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public UploadOptions setAcl(String acl) {
        this.acl = acl;
        return this;
    }

    public UploadOptions setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public UploadOptions setUseMultipart(boolean useMultipart) {
        this.useMultipart = useMultipart;
        return this;
    }

    public UploadOptions setPartSize(long partSize) {
        this.partSize = partSize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadOptions)) {
            return false;
        }
        UploadOptions other = (UploadOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrivate() != other.isPrivate()) {
            return false;
        }
        if (this.isUseMultipart() != other.isUseMultipart()) {
            return false;
        }
        if (this.getPartSize() != other.getPartSize()) {
            return false;
        }
        Long this$expireTime = this.getExpireTime();
        Long other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        Long this$maxSize = this.getMaxSize();
        Long other$maxSize = other.getMaxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$acl = this.getAcl();
        String other$acl = other.getAcl();
        return !(this$acl == null ? other$acl != null : !this$acl.equals(other$acl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrivate() ? 79 : 97);
        result = result * 59 + (this.isUseMultipart() ? 79 : 97);
        long $partSize = this.getPartSize();
        result = result * 59 + (int)($partSize >>> 32 ^ $partSize);
        Long $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        Long $maxSize = this.getMaxSize();
        result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $acl = this.getAcl();
        result = result * 59 + ($acl == null ? 43 : $acl.hashCode());
        return result;
    }

    public String toString() {
        return "UploadOptions(isPrivate=" + this.isPrivate() + ", expireTime=" + this.getExpireTime() + ", contentType=" + this.getContentType() + ", acl=" + this.getAcl() + ", maxSize=" + this.getMaxSize() + ", useMultipart=" + this.isUseMultipart() + ", partSize=" + this.getPartSize() + ")";
    }
}

