/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.impl;

import cn.com.anysdk.oss.api.IOssConfig;
import cn.com.anysdk.oss.api.IOssService;
import cn.com.anysdk.oss.api.UploadOptions;
import cn.com.anysdk.oss.exception.OssException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOssService
implements IOssService {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssService.class);
    private final OSS ossClient;
    private final IOssConfig config;

    public AliyunOssService(IOssConfig config) {
        this.config = config;
        this.ossClient = new OSSClientBuilder().build(config.getEndpoint(), config.getAccessKeyId(), config.getAccessKeySecret());
    }

    @Override
    public String uploadFile(String objectKey, File file) {
        return this.uploadFile(objectKey, file, UploadOptions.publicFile());
    }

    @Override
    public String uploadFile(String objectKey, InputStream inputStream, long size) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(size);
        try {
            PutObjectResult result = this.ossClient.putObject(this.config.getBucketName(), objectKey, inputStream, metadata);
            log.debug("Upload file success, path: {}, ETag: {}", (Object)objectKey, (Object)result.getETag());
            return this.getFileUrl(objectKey);
        }
        catch (Exception e) {
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String uploadFile(String objectKey, File file, UploadOptions options) {
        try {
            ObjectMetadata metadata = this.createMetadata(options);
            PutObjectResult result = this.ossClient.putObject(this.config.getBucketName(), objectKey, file, metadata);
            log.debug("Upload file success, path: {}, ETag: {}", (Object)objectKey, (Object)result.getETag());
            return this.getFileUrl(objectKey, options.isPrivate() ? options.getExpireTime() : null);
        }
        catch (Exception e) {
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream downloadFile(String objectKey) {
        try {
            OSSObject ossObject = this.ossClient.getObject(this.config.getBucketName(), objectKey);
            return ossObject.getObjectContent();
        }
        catch (Exception e) {
            throw new OssException("Download file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFile(String objectKey) {
        try {
            this.ossClient.deleteObject(this.config.getBucketName(), objectKey);
        }
        catch (Exception e) {
            throw new OssException("Delete file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFiles(List<String> objectKeys) {
        try {
            DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.config.getBucketName());
            deleteRequest.setKeys(objectKeys);
            this.ossClient.deleteObjects(deleteRequest);
        }
        catch (Exception e) {
            throw new OssException("Delete files failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String getFileUrl(String objectKey) {
        return this.getFileUrl(objectKey, null);
    }

    @Override
    public String getSignedUrl(String objectKey, long expireSeconds) {
        return this.getFileUrl(objectKey, expireSeconds);
    }

    @Override
    public boolean doesObjectExist(String objectKey) {
        try {
            return this.ossClient.doesObjectExist(this.config.getBucketName(), objectKey);
        }
        catch (Exception e) {
            log.error("Check file exists failed: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public IOssConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean validateConfig() {
        return this.config != null && this.config.getAccessKeyId() != null && !this.config.getAccessKeyId().trim().isEmpty() && this.config.getAccessKeySecret() != null && !this.config.getAccessKeySecret().trim().isEmpty() && this.config.getEndpoint() != null && !this.config.getEndpoint().trim().isEmpty() && this.config.getBucketName() != null && !this.config.getBucketName().trim().isEmpty();
    }

    private String getFileUrl(String objectKey, Long expireTime) {
        try {
            if (this.config.isPrivateMode() || expireTime != null) {
                Date expiration = new Date(System.currentTimeMillis() + (expireTime != null ? expireTime * 1000L : 3600000L));
                URL url = this.ossClient.generatePresignedUrl(this.config.getBucketName(), objectKey, expiration);
                return url.toString();
            }
            return String.format("https://%s.%s/%s", this.config.getBucketName(), this.config.getEndpoint(), objectKey);
        }
        catch (Exception e) {
            throw new OssException("Generate URL failed: " + e.getMessage(), e);
        }
    }

    private ObjectMetadata createMetadata(UploadOptions options) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (options.getContentType() != null) {
            metadata.setContentType(options.getContentType());
        }
        if (options.getAcl() != null) {
            metadata.setObjectAcl(CannedAccessControlList.parse((String)options.getAcl()));
        }
        return metadata;
    }
}

