/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.impl;

import cn.com.anysdk.core.util.StringUtils;
import cn.com.anysdk.oss.api.IOssConfig;
import cn.com.anysdk.oss.api.IOssService;
import cn.com.anysdk.oss.api.UploadOptions;
import cn.com.anysdk.oss.config.LocalFileSystemConfig;
import cn.com.anysdk.oss.exception.OssException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystemService
implements IOssService {
    private static final Logger log = LoggerFactory.getLogger(LocalFileSystemService.class);
    private final LocalFileSystemConfig config;

    public LocalFileSystemService(IOssConfig config) {
        if (!(config instanceof LocalFileSystemConfig)) {
            throw new IllegalArgumentException("Config must be instance of LocalFileSystemConfig");
        }
        this.config = (LocalFileSystemConfig)config;
    }

    @Override
    public String uploadFile(String objectKey, File file) {
        return this.uploadFile(objectKey, file, UploadOptions.publicFile());
    }

    @Override
    public String uploadFile(String objectKey, InputStream inputStream, long size) {
        try {
            Path targetPath = this.getFullPath(objectKey);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, targetPath, new CopyOption[0]);
            log.debug("Upload file success, path: {}", (Object)objectKey);
            return this.getFileUrl(objectKey);
        }
        catch (IOException e) {
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String uploadFile(String objectKey, File file, UploadOptions options) {
        try {
            if (StringUtils.isBlank((String)objectKey)) {
                throw new IllegalArgumentException("Object key cannot be empty");
            }
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("File does not exist");
            }
            Path targetPath = this.getFullPath(objectKey);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.copy(file.toPath(), targetPath, new CopyOption[0]);
            log.debug("Upload file success, path: {}", (Object)objectKey);
            return this.getFileUrl(objectKey, options.isPrivate() ? options.getExpireTime() : null);
        }
        catch (IOException e) {
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream downloadFile(String objectKey) {
        try {
            if (StringUtils.isBlank((String)objectKey)) {
                throw new IllegalArgumentException("Object key cannot be empty");
            }
            Path filePath = this.getFullPath(objectKey);
            if (!Files.exists(filePath, new LinkOption[0])) {
                throw new FileNotFoundException("File not found: " + objectKey);
            }
            log.debug("Download file success, path: {}", (Object)objectKey);
            return new FileInputStream(filePath.toFile());
        }
        catch (IOException e) {
            throw new OssException("Download file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFile(String objectKey) {
        try {
            if (StringUtils.isBlank((String)objectKey)) {
                throw new IllegalArgumentException("Object key cannot be empty");
            }
            Path filePath = this.getFullPath(objectKey);
            if (!Files.exists(filePath, new LinkOption[0])) {
                throw new FileNotFoundException("File not found: " + objectKey);
            }
            Files.delete(filePath);
            log.debug("Delete file success, path: {}", (Object)objectKey);
        }
        catch (IOException e) {
            throw new OssException("Delete file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFiles(List<String> objectKeys) {
        for (String objectKey : objectKeys) {
            this.deleteFile(objectKey);
        }
    }

    @Override
    public String getFileUrl(String objectKey) {
        return this.getFileUrl(objectKey, null);
    }

    @Override
    public String getSignedUrl(String objectKey, long expireSeconds) {
        return this.getFileUrl(objectKey, expireSeconds);
    }

    @Override
    public boolean doesObjectExist(String objectKey) {
        if (StringUtils.isBlank((String)objectKey)) {
            return false;
        }
        return Files.exists(this.getFullPath(objectKey), new LinkOption[0]);
    }

    @Override
    public IOssConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean validateConfig() {
        return this.config != null && this.config.getEndpoint() != null && !this.config.getEndpoint().trim().isEmpty();
    }

    private Path getFullPath(String objectKey) {
        return Paths.get(this.config.getBasePath(), objectKey);
    }

    private String getFileUrl(String objectKey, Long expireTime) {
        Path filePath = this.getFullPath(objectKey);
        if (this.config.isPrivateMode() || expireTime != null) {
            return filePath.toString();
        }
        return String.format("file://%s", filePath);
    }
}

