/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.impl;

import cn.com.anysdk.oss.api.IOssConfig;
import cn.com.anysdk.oss.api.IOssService;
import cn.com.anysdk.oss.exception.OssException;
import cn.com.anysdk.oss.factory.OssServiceFactory;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssServiceManager {
    private static final Logger log = LoggerFactory.getLogger(OssServiceManager.class);
    private final ConcurrentHashMap<String, IOssService> serviceCache = new ConcurrentHashMap();
    private IOssService currentService;
    private IOssConfig currentConfig;

    public synchronized IOssService switchProvider(IOssConfig config) {
        try {
            if (!this.validateConfig(config)) {
                throw new OssException("Invalid OSS configuration");
            }
            String provider = config.getProvider();
            log.info("Switching OSS provider to: {}", (Object)provider);
            IOssService service = this.serviceCache.get(provider);
            if (service == null) {
                service = OssServiceFactory.createService(config);
                this.serviceCache.put(provider, service);
            }
            this.currentService = service;
            this.currentConfig = config;
            log.info("Successfully switched to provider: {}", (Object)provider);
            return service;
        }
        catch (Exception e) {
            log.error("Failed to switch OSS provider", (Throwable)e);
            throw new OssException("Failed to switch OSS provider: " + e.getMessage(), e);
        }
    }

    public IOssConfig getCurrentConfig() {
        return this.currentConfig;
    }

    public IOssService getCurrentService() {
        if (this.currentService == null) {
            throw new OssException("No OSS service is currently configured");
        }
        return this.currentService;
    }

    public boolean validateConfig(IOssConfig config) {
        if (config == null) {
            return false;
        }
        String provider = config.getProvider();
        if (provider == null || provider.trim().isEmpty()) {
            return false;
        }
        return switch (provider.toLowerCase()) {
            case "aliyun" -> this.validateAliyunConfig(config);
            case "tencent" -> this.validateTencentConfig(config);
            case "minio" -> this.validateMinioConfig(config);
            case "local" -> this.validateLocalConfig(config);
            default -> false;
        };
    }

    private boolean validateAliyunConfig(IOssConfig config) {
        return config.getAccessKeyId() != null && !config.getAccessKeyId().trim().isEmpty() && config.getAccessKeySecret() != null && !config.getAccessKeySecret().trim().isEmpty() && config.getEndpoint() != null && !config.getEndpoint().trim().isEmpty() && config.getBucketName() != null && !config.getBucketName().trim().isEmpty();
    }

    private boolean validateTencentConfig(IOssConfig config) {
        return config.getAccessKeyId() != null && !config.getAccessKeyId().trim().isEmpty() && config.getAccessKeySecret() != null && !config.getAccessKeySecret().trim().isEmpty() && config.getEndpoint() != null && !config.getEndpoint().trim().isEmpty() && config.getBucketName() != null && !config.getBucketName().trim().isEmpty();
    }

    private boolean validateMinioConfig(IOssConfig config) {
        return config.getAccessKeyId() != null && !config.getAccessKeyId().trim().isEmpty() && config.getAccessKeySecret() != null && !config.getAccessKeySecret().trim().isEmpty() && config.getEndpoint() != null && !config.getEndpoint().trim().isEmpty() && config.getBucketName() != null && !config.getBucketName().trim().isEmpty();
    }

    private boolean validateLocalConfig(IOssConfig config) {
        return config.getEndpoint() != null && !config.getEndpoint().trim().isEmpty();
    }
}

