/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.impl;

import cn.com.anysdk.oss.api.IOssConfig;
import cn.com.anysdk.oss.api.IOssService;
import cn.com.anysdk.oss.api.UploadOptions;
import cn.com.anysdk.oss.exception.OssException;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentCloudOssService
implements IOssService {
    private static final Logger log = LoggerFactory.getLogger(TencentCloudOssService.class);
    private final COSClient cosClient;
    private final IOssConfig config;

    public TencentCloudOssService(IOssConfig config) {
        this.config = config;
        BasicCOSCredentials cred = new BasicCOSCredentials(config.getAccessKeyId(), config.getAccessKeySecret());
        ClientConfig clientConfig = new ClientConfig(new Region(config.getEndpoint()));
        this.cosClient = new COSClient((COSCredentials)cred, clientConfig);
    }

    @Override
    public String uploadFile(String objectKey, File file) {
        log.info("Uploading file with key: {}", (Object)objectKey);
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.config.getBucketName(), objectKey, file);
            this.cosClient.putObject(putObjectRequest);
            String url = this.getFileUrl(objectKey);
            log.info("File uploaded successfully. URL: {}", (Object)url);
            return url;
        }
        catch (Exception e) {
            log.error("Failed to upload file with key: {}", (Object)objectKey, (Object)e);
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String uploadFile(String objectKey, InputStream inputStream, long size) {
        log.info("Uploading file with key: {}, size: {}", (Object)objectKey, (Object)size);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(size);
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.config.getBucketName(), objectKey, inputStream, metadata);
            this.cosClient.putObject(putObjectRequest);
            String url = this.getFileUrl(objectKey);
            log.info("File uploaded successfully. URL: {}", (Object)url);
            return url;
        }
        catch (Exception e) {
            log.error("Failed to upload file with key: {}", (Object)objectKey, (Object)e);
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String uploadFile(String objectKey, File file, UploadOptions options) {
        log.info("Uploading file with key: {}, options: {}", (Object)objectKey, (Object)options);
        try {
            ObjectMetadata metadata = this.createMetadata(options);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.config.getBucketName(), objectKey, file);
            putObjectRequest.setMetadata(metadata);
            this.cosClient.putObject(putObjectRequest);
            String url = this.getFileUrl(objectKey, options.isPrivate() ? options.getExpireTime() : null);
            log.info("File uploaded successfully. URL: {}", (Object)url);
            return url;
        }
        catch (Exception e) {
            log.error("Failed to upload file with key: {}", (Object)objectKey, (Object)e);
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream downloadFile(String objectKey) {
        log.info("Downloading file with key: {}", (Object)objectKey);
        try {
            COSObjectInputStream inputStream = this.cosClient.getObject(this.config.getBucketName(), objectKey).getObjectContent();
            log.info("File downloaded successfully with key: {}", (Object)objectKey);
            return inputStream;
        }
        catch (Exception e) {
            log.error("Failed to download file with key: {}", (Object)objectKey, (Object)e);
            throw new OssException("Download file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFile(String objectKey) {
        log.info("Deleting file with key: {}", (Object)objectKey);
        try {
            this.cosClient.deleteObject(this.config.getBucketName(), objectKey);
            log.info("File deleted successfully with key: {}", (Object)objectKey);
        }
        catch (Exception e) {
            log.error("Failed to delete file with key: {}", (Object)objectKey, (Object)e);
            throw new OssException("Delete file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFiles(List<String> objectKeys) {
        log.info("Deleting files with keys: {}", objectKeys);
        try {
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.config.getBucketName());
            deleteObjectsRequest.setKeys(objectKeys.stream().map(DeleteObjectsRequest.KeyVersion::new).toList());
            this.cosClient.deleteObjects(deleteObjectsRequest);
            log.info("Files deleted successfully with keys: {}", objectKeys);
        }
        catch (Exception e) {
            log.error("Failed to delete files with keys: {}", objectKeys, (Object)e);
            throw new OssException("Delete files failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String getFileUrl(String objectKey) {
        log.info("Generating file URL for key: {}", (Object)objectKey);
        return this.getFileUrl(objectKey, null);
    }

    @Override
    public String getSignedUrl(String objectKey, long expireSeconds) {
        log.info("Generating signed URL for key: {}, expireSeconds: {}", (Object)objectKey, (Object)expireSeconds);
        return this.getFileUrl(objectKey, expireSeconds);
    }

    @Override
    public boolean doesObjectExist(String objectKey) {
        log.info("Checking existence of object with key: {}", (Object)objectKey);
        boolean exists = this.cosClient.doesObjectExist(this.config.getBucketName(), objectKey);
        log.info("Object with key: {} exists: {}", (Object)objectKey, (Object)exists);
        return exists;
    }

    @Override
    public IOssConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean validateConfig() {
        return this.config != null && this.config.getAccessKeyId() != null && !this.config.getAccessKeyId().trim().isEmpty() && this.config.getAccessKeySecret() != null && !this.config.getAccessKeySecret().trim().isEmpty() && this.config.getEndpoint() != null && !this.config.getEndpoint().trim().isEmpty() && this.config.getBucketName() != null && !this.config.getBucketName().trim().isEmpty();
    }

    private String getFileUrl(String objectKey, Long expireTime) {
        log.info("Generating file URL for key: {}, expireTime: {}", (Object)objectKey, (Object)expireTime);
        try {
            if (this.config.isPrivateMode() || expireTime != null) {
                Date expiration = new Date(System.currentTimeMillis() + (expireTime != null ? expireTime * 1000L : 3600000L));
                GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.config.getBucketName(), objectKey);
                request.setExpiration(expiration);
                URL url = this.cosClient.generatePresignedUrl(request);
                log.info("Generated signed URL for key: {}", (Object)objectKey);
                return url.toString();
            }
            String url = String.format("https://%s.%s/%s", this.config.getBucketName(), this.config.getEndpoint(), objectKey);
            log.info("Generated public URL for key: {}", (Object)objectKey);
            return url;
        }
        catch (Exception e) {
            log.error("Failed to generate URL for key: {}", (Object)objectKey, (Object)e);
            throw new OssException("Generate URL failed: " + e.getMessage(), e);
        }
    }

    private ObjectMetadata createMetadata(UploadOptions options) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (options.getContentType() != null) {
            metadata.setContentType(options.getContentType());
        }
        return metadata;
    }
}

