/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.monitor;

import cn.com.anysdk.oss.api.OssExceptionListener;
import cn.com.anysdk.oss.exception.OssException;
import cn.com.anysdk.oss.monitor.OssOperationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssMonitorManager {
    private static final Logger log = LoggerFactory.getLogger(OssMonitorManager.class);
    private static final OssMonitorManager INSTANCE = new OssMonitorManager();
    private final List<OssExceptionListener> listeners = new ArrayList<OssExceptionListener>();
    private final Map<String, AtomicLong> operationCounters = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> errorCounters = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> durationMetrics = new ConcurrentHashMap<String, AtomicLong>();

    private OssMonitorManager() {
    }

    public static OssMonitorManager getInstance() {
        return INSTANCE;
    }

    public void addListener(OssExceptionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(OssExceptionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyListeners(OssException exception, OssOperationContext context) {
        for (OssExceptionListener listener : this.listeners) {
            try {
                listener.onException(exception, context);
            }
            catch (Exception e) {
                log.error("Error notifying listener: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void handleException(OssException exception, OssOperationContext context) {
        String operationKey = String.format("%s_%s", new Object[]{context.getProvider(), context.getOperationType()});
        this.errorCounters.computeIfAbsent(operationKey, k -> new AtomicLong()).incrementAndGet();
        this.notifyListeners(exception, context);
    }

    public void recordOperationStart(OssOperationContext context) {
        String operationKey = String.format("%s_%s", new Object[]{context.getProvider(), context.getOperationType()});
        this.operationCounters.computeIfAbsent(operationKey, k -> new AtomicLong()).incrementAndGet();
    }

    public void recordOperationEnd(OssOperationContext context) {
        String operationKey = String.format("%s_%s", new Object[]{context.getProvider(), context.getOperationType()});
        this.durationMetrics.computeIfAbsent(operationKey, k -> new AtomicLong()).addAndGet(context.getDuration());
    }

    public long getOperationCount(String provider, OssOperationContext.OperationType type) {
        String key = String.format("%s_%s", new Object[]{provider, type});
        AtomicLong counter = this.operationCounters.get(key);
        return counter != null ? counter.get() : 0L;
    }

    public long getErrorCount(String provider, OssOperationContext.OperationType type) {
        String key = String.format("%s_%s", new Object[]{provider, type});
        AtomicLong counter = this.errorCounters.get(key);
        return counter != null ? counter.get() : 0L;
    }

    public double getAverageOperationDuration(String provider, OssOperationContext.OperationType type) {
        String key = String.format("%s_%s", new Object[]{provider, type});
        AtomicLong totalDuration = this.durationMetrics.get(key);
        AtomicLong totalCount = this.operationCounters.get(key);
        if (totalDuration != null && totalCount != null && totalCount.get() > 0L) {
            return (double)totalDuration.get() / (double)totalCount.get();
        }
        return 0.0;
    }

    public void resetMetrics() {
        this.operationCounters.clear();
        this.errorCounters.clear();
        this.durationMetrics.clear();
    }
}

