/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.monitor;

import java.util.Map;

public class OssOperationContext {
    private OperationType operationType;
    private Provider provider;
    private String path;
    private long duration;
    private long fileSize;
    private boolean isPrivate;
    private String requestId;
    private Map<String, Object> extraInfo;

    OssOperationContext(OperationType operationType, Provider provider, String path, long duration, long fileSize, boolean isPrivate, String requestId, Map<String, Object> extraInfo) {
        this.operationType = operationType;
        this.provider = provider;
        this.path = path;
        this.duration = duration;
        this.fileSize = fileSize;
        this.isPrivate = isPrivate;
        this.requestId = requestId;
        this.extraInfo = extraInfo;
    }

    public static OssOperationContextBuilder builder() {
        return new OssOperationContextBuilder();
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getPath() {
        return this.path;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, Object> getExtraInfo() {
        return this.extraInfo;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setExtraInfo(Map<String, Object> extraInfo) {
        this.extraInfo = extraInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssOperationContext)) {
            return false;
        }
        OssOperationContext other = (OssOperationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getFileSize() != other.getFileSize()) {
            return false;
        }
        if (this.isPrivate() != other.isPrivate()) {
            return false;
        }
        OperationType this$operationType = this.getOperationType();
        OperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        Provider this$provider = this.getProvider();
        Provider other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !((Object)((Object)this$provider)).equals((Object)other$provider)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        Map<String, Object> this$extraInfo = this.getExtraInfo();
        Map<String, Object> other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !((Object)this$extraInfo).equals(other$extraInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OssOperationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        long $fileSize = this.getFileSize();
        result = result * 59 + (int)($fileSize >>> 32 ^ $fileSize);
        result = result * 59 + (this.isPrivate() ? 79 : 97);
        OperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        Provider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : ((Object)((Object)$provider)).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        Map<String, Object> $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : ((Object)$extraInfo).hashCode());
        return result;
    }

    public String toString() {
        return "OssOperationContext(operationType=" + String.valueOf((Object)this.getOperationType()) + ", provider=" + String.valueOf((Object)this.getProvider()) + ", path=" + this.getPath() + ", duration=" + this.getDuration() + ", fileSize=" + this.getFileSize() + ", isPrivate=" + this.isPrivate() + ", requestId=" + this.getRequestId() + ", extraInfo=" + String.valueOf(this.getExtraInfo()) + ")";
    }

    public static enum OperationType {
        UPLOAD,
        DOWNLOAD,
        DELETE,
        GET_URL,
        GET_SIGNED_URL,
        CHECK_EXIST;

    }

    public static enum Provider {
        ALIYUN,
        TENCENT,
        QINIU,
        LOCAL;

    }

    public static class OssOperationContextBuilder {
        private OperationType operationType;
        private Provider provider;
        private String path;
        private long duration;
        private long fileSize;
        private boolean isPrivate;
        private String requestId;
        private Map<String, Object> extraInfo;

        OssOperationContextBuilder() {
        }

        public OssOperationContextBuilder operationType(OperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public OssOperationContextBuilder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public OssOperationContextBuilder path(String path) {
            this.path = path;
            return this;
        }

        public OssOperationContextBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public OssOperationContextBuilder fileSize(long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public OssOperationContextBuilder isPrivate(boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public OssOperationContextBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public OssOperationContextBuilder extraInfo(Map<String, Object> extraInfo) {
            this.extraInfo = extraInfo;
            return this;
        }

        public OssOperationContext build() {
            return new OssOperationContext(this.operationType, this.provider, this.path, this.duration, this.fileSize, this.isPrivate, this.requestId, this.extraInfo);
        }

        public String toString() {
            return "OssOperationContext.OssOperationContextBuilder(operationType=" + String.valueOf((Object)this.operationType) + ", provider=" + String.valueOf((Object)this.provider) + ", path=" + this.path + ", duration=" + this.duration + ", fileSize=" + this.fileSize + ", isPrivate=" + this.isPrivate + ", requestId=" + this.requestId + ", extraInfo=" + String.valueOf(this.extraInfo) + ")";
        }
    }
}

