/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.exception;

import cn.com.anysdk.oss.exception.OssException;
import cn.com.anysdk.oss.monitor.OssMonitorManager;
import cn.com.anysdk.oss.monitor.OssOperationContext;
import java.io.File;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(OssExceptionHandler.class);
    private static final OssExceptionHandler INSTANCE = new OssExceptionHandler();
    private final OssMonitorManager monitorManager = OssMonitorManager.getInstance();

    private OssExceptionHandler() {
    }

    public static OssExceptionHandler getInstance() {
        return INSTANCE;
    }

    public Object handleMethodCall(Object target, Method method, Object[] args) throws Throwable {
        LocalDateTime startTime = LocalDateTime.now();
        try {
            return method.invoke(target, args);
        }
        catch (Throwable e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof OssException) {
                this.handleOssException((OssException)cause, target, method, args, startTime);
            } else {
                OssException ossException = new OssException("OSS operation failed", cause);
                this.handleOssException(ossException, target, method, args, startTime);
            }
            throw cause;
        }
    }

    private void handleOssException(OssException exception, Object target, Method method, Object[] args, LocalDateTime startTime) {
        try {
            OssOperationContext context = this.buildOperationContext(target, method, args, startTime);
            this.monitorManager.handleException(exception, context);
        }
        catch (Exception e) {
            log.error("Failed to handle OSS exception", (Throwable)e);
        }
    }

    private OssOperationContext buildOperationContext(Object target, Method method, Object[] args, LocalDateTime startTime) {
        return OssOperationContext.builder().operationType(this.getOperationType(method)).provider(this.getProvider(target)).path(this.getPath(args)).fileSize(this.getFileSize(args)).duration(System.currentTimeMillis() - startTime.toEpochSecond(ZoneOffset.UTC) * 1000L).build();
    }

    private OssOperationContext.OperationType getOperationType(Method method) {
        String methodName = method.getName().toLowerCase();
        if (methodName.contains("upload")) {
            return OssOperationContext.OperationType.UPLOAD;
        }
        if (methodName.contains("download")) {
            return OssOperationContext.OperationType.DOWNLOAD;
        }
        if (methodName.contains("delete")) {
            return OssOperationContext.OperationType.DELETE;
        }
        if (methodName.contains("url")) {
            return OssOperationContext.OperationType.GET_URL;
        }
        if (methodName.contains("exists")) {
            return OssOperationContext.OperationType.CHECK_EXIST;
        }
        return OssOperationContext.OperationType.UPLOAD;
    }

    private OssOperationContext.Provider getProvider(Object target) {
        String className = target.getClass().getSimpleName().toLowerCase();
        if (className.contains("aliyun")) {
            return OssOperationContext.Provider.ALIYUN;
        }
        if (className.contains("tencent")) {
            return OssOperationContext.Provider.TENCENT;
        }
        if (className.contains("qiniu")) {
            return OssOperationContext.Provider.QINIU;
        }
        if (className.contains("local")) {
            return OssOperationContext.Provider.LOCAL;
        }
        return OssOperationContext.Provider.ALIYUN;
    }

    private String getPath(Object[] args) {
        if (args != null) {
            for (Object arg : args) {
                if (!(arg instanceof String)) continue;
                return (String)arg;
            }
        }
        return null;
    }

    private long getFileSize(Object[] args) {
        if (args != null) {
            for (Object arg : args) {
                if (arg instanceof File) {
                    return ((File)arg).length();
                }
                if (!(arg instanceof byte[])) continue;
                return ((byte[])arg).length;
            }
        }
        return 0L;
    }
}

