/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.factory;

import cn.com.anysdk.oss.api.IOssConfig;
import cn.com.anysdk.oss.api.IOssService;
import cn.com.anysdk.oss.exception.OssException;
import cn.com.anysdk.oss.impl.AliyunOssService;
import cn.com.anysdk.oss.impl.LocalFileSystemService;
import cn.com.anysdk.oss.impl.MinioOssService;
import cn.com.anysdk.oss.impl.TencentCloudOssService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(OssServiceFactory.class);

    public static IOssService createService(IOssConfig config) {
        if (config == null) {
            log.error("OSS config is null. Cannot create service.");
            throw new OssException("OSS config cannot be null");
        }
        String provider = config.getProvider();
        log.info("Creating OSS service for provider: {}", (Object)provider);
        try {
            return switch (provider.toLowerCase()) {
                case "aliyun" -> {
                    log.info("Initializing Aliyun OSS service.");
                    yield new AliyunOssService(config);
                }
                case "local" -> {
                    log.info("Initializing Local File System service.");
                    yield new LocalFileSystemService(config);
                }
                case "tencent" -> {
                    log.info("Initializing Tencent Cloud OSS service.");
                    yield new TencentCloudOssService(config);
                }
                case "minio" -> {
                    log.info("Initializing Minio Oss service.");
                    yield new MinioOssService(config);
                }
                default -> {
                    log.error("Unsupported OSS provider: {}", (Object)provider);
                    throw new OssException("Unsupported OSS provider: " + provider);
                }
            };
        }
        catch (Exception e) {
            log.error("Failed to create OSS service for provider: {}", (Object)provider, (Object)e);
            throw new OssException("Failed to create OSS service: " + e.getMessage(), e);
        }
    }
}

