/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.factory;

import cn.com.anysdk.oss.api.IOssService;
import cn.com.anysdk.oss.exception.OssException;
import cn.com.anysdk.oss.monitor.OssMonitorManager;
import cn.com.anysdk.oss.monitor.OssOperationContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssServiceProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(OssServiceProxyFactory.class);

    public static IOssService createProxy(IOssService service) {
        return (IOssService)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{IOssService.class}, (InvocationHandler)new OssServiceInvocationHandler(service));
    }

    private static class OssServiceInvocationHandler
    implements InvocationHandler {
        private final IOssService target;

        public OssServiceInvocationHandler(IOssService target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            OssOperationContext context = OssOperationContext.builder().provider(this.getProvider(this.target.getClass().getSimpleName())).operationType(this.getOperationType(method.getName())).build();
            try {
                Object result = method.invoke((Object)this.target, args);
                return result;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof OssException) {
                    OssMonitorManager.getInstance().notifyListeners((OssException)cause, context);
                    throw cause;
                }
                OssException ossException = new OssException("Operation failed: " + e.getMessage(), e);
                OssMonitorManager.getInstance().notifyListeners(ossException, context);
                throw ossException;
            }
        }

        private OssOperationContext.Provider getProvider(String className) {
            if (className.contains("Aliyun")) {
                return OssOperationContext.Provider.ALIYUN;
            }
            if (className.contains("Tencent")) {
                return OssOperationContext.Provider.TENCENT;
            }
            if (className.contains("Qiniu")) {
                return OssOperationContext.Provider.QINIU;
            }
            return OssOperationContext.Provider.LOCAL;
        }

        private OssOperationContext.OperationType getOperationType(String methodName) {
            switch (methodName) {
                case "uploadFile": {
                    return OssOperationContext.OperationType.UPLOAD;
                }
                case "downloadFile": {
                    return OssOperationContext.OperationType.DOWNLOAD;
                }
                case "deleteFile": 
                case "deleteFiles": {
                    return OssOperationContext.OperationType.DELETE;
                }
                case "getFileUrl": {
                    return OssOperationContext.OperationType.GET_URL;
                }
                case "getSignedUrl": {
                    return OssOperationContext.OperationType.GET_SIGNED_URL;
                }
                case "doesObjectExist": {
                    return OssOperationContext.OperationType.CHECK_EXIST;
                }
            }
            return null;
        }
    }
}

