/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.oss.impl;

import cn.com.anysdk.oss.api.IOssConfig;
import cn.com.anysdk.oss.api.IOssService;
import cn.com.anysdk.oss.api.UploadOptions;
import cn.com.anysdk.oss.config.MinioConfig;
import cn.com.anysdk.oss.exception.OssException;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.StatObjectArgs;
import io.minio.UploadObjectArgs;
import io.minio.http.Method;
import io.minio.messages.DeleteObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioOssService
implements IOssService {
    private static final Logger log = LoggerFactory.getLogger(MinioOssService.class);
    private final MinioClient minioClient;
    private final MinioConfig minioConfig;
    private final IOssConfig config;

    public MinioOssService(IOssConfig config) {
        if (!(config instanceof MinioConfig)) {
            throw new IllegalArgumentException("Config must be instance of MinioConfig");
        }
        this.minioConfig = (MinioConfig)config;
        this.minioClient = this.minioConfig.createMinioClient();
        this.config = config;
    }

    @Override
    public String uploadFile(String objectKey, File file) {
        try {
            this.minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectKey)).filename(file.getAbsolutePath()).build());
            return this.getFileUrl(objectKey);
        }
        catch (Exception e) {
            throw new OssException("Failed to upload file: " + e.getMessage(), e);
        }
    }

    @Override
    public String uploadFile(String objectKey, InputStream inputStream, long size) {
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectKey)).stream(inputStream, size, -1L).build());
            log.debug("Upload file success, path: {}", (Object)objectKey);
            return this.getFileUrl(objectKey);
        }
        catch (Exception e) {
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String uploadFile(String objectKey, File file, UploadOptions options) {
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectKey)).stream((InputStream)new FileInputStream(file), file.length(), -1L).contentType(options.getContentType()).build());
            log.debug("Upload file success, path: {}", (Object)objectKey);
            return this.getFileUrl(objectKey, options.isPrivate() ? options.getExpireTime() : null);
        }
        catch (Exception e) {
            throw new OssException("Upload file failed: " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream downloadFile(String objectKey) {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectKey)).build());
        }
        catch (Exception e) {
            throw new OssException("Failed to download file: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFile(String objectKey) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectKey)).build());
        }
        catch (Exception e) {
            throw new OssException("Failed to delete file: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFiles(List<String> objectKeys) {
        try {
            List<DeleteObject> objects = objectKeys.stream().map(DeleteObject::new).toList();
            this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(this.minioConfig.getBucketName())).objects(objects).build());
        }
        catch (Exception e) {
            throw new OssException("Delete files failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String getFileUrl(String objectKey) {
        try {
            String url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(this.minioConfig.getBucketName())).object(objectKey)).expiry(7, TimeUnit.DAYS).build());
            return this.minioConfig.getCustomDomain() != null ? url.replace(this.minioConfig.getEndpoint(), this.minioConfig.getCustomDomain()) : url;
        }
        catch (Exception e) {
            throw new OssException("Failed to get file URL: " + e.getMessage(), e);
        }
    }

    @Override
    public String getSignedUrl(String objectKey, long expireSeconds) {
        return this.getFileUrl(objectKey, expireSeconds);
    }

    @Override
    public boolean doesObjectExist(String objectKey) {
        try {
            this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectKey)).build());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public IOssConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean validateConfig() {
        return this.config != null && this.config.getAccessKeyId() != null && !this.config.getAccessKeyId().trim().isEmpty() && this.config.getAccessKeySecret() != null && !this.config.getAccessKeySecret().trim().isEmpty() && this.config.getEndpoint() != null && !this.config.getEndpoint().trim().isEmpty() && this.config.getBucketName() != null && !this.config.getBucketName().trim().isEmpty();
    }

    private String getFileUrl(String objectKey, Long expireTime) {
        try {
            if (this.minioConfig.isPrivateMode() || expireTime != null) {
                String url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.minioConfig.getBucketName())).object(objectKey)).expiry(expireTime != null ? expireTime.intValue() : 3600, TimeUnit.SECONDS).build());
                return url;
            }
            return String.format("http://%s/%s/%s", this.minioConfig.getEndpoint(), this.minioConfig.getBucketName(), objectKey);
        }
        catch (Exception e) {
            throw new OssException("Generate URL failed: " + e.getMessage(), e);
        }
    }
}

