package cn.com.anysdk.redis.config;

import cn.com.anysdk.redis.api.IRedisConfig;

/**
 * 本地Redis配置
 */
public class LocalRedisConfig implements IRedisConfig {

    private String host = "localhost";
    private int port = 6379;
    private String password;
    private int database = 0;

    @Override
    public String getHost() {
        return host;
    }

    public LocalRedisConfig setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public int getPort() {
        return port;
    }

    public LocalRedisConfig setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public String getPassword() {
        return password;
    }

    public LocalRedisConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public int getDatabase() {
        return database;
    }

    public LocalRedisConfig setDatabase(int database) {
        this.database = database;
        return this;
    }
}