package cn.com.anysdk.redis.config;

import cn.com.anysdk.redis.api.IRedisConfig;
import lombok.Data;

/**
 * 腾讯云Redis配置
 * 支持标准版、集群版、读写分离版
 */
@Data
public class TencentRedisConfig implements IRedisConfig {

    private String endpoint;
    private int port = 6379;
    private String secretId;
    private String secretKey;
    private String token;
    private String password;
    private int database = 0;
    private String mode = "standard"; // standard, cluster, master-slave

    // 腾讯云特有配置
    private String region;
    private String instanceId;
    private String vpcId;
    private String subnetId;
    private String projectId;

    // 集群节点信息
    private String[] clusterNodes;
    private int maxRedirects = 3;

    // 读写分离配置
    private String[] slaveNodes;
    private boolean enableReadOnlySlave = false;

    // 网络配置
    private String wanAddress;
    private String lanAddress;
    private int wanPort = 6379;
    private int lanPort = 6379;

    @Override
    public String getHost() {
        return endpoint;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public String getPassword() {
        return password;
    }

    @Override
    public int getDatabase() {
        return database;
    }
}