package cn.com.anysdk.redis.event;

import lombok.extern.slf4j.Slf4j;

/**
 * 默认Redis事件监听器实现
 * 主要用于日志记录
 */
@Slf4j
public class DefaultRedisEventListener implements RedisEventListener {

    @Override
    public void onConnect(RedisConnectionEvent event) {
        log.info("Redis连接成功 - 环境: {}, 主机: {}:{}, 耗时: {}ms",
                event.getEnvironment(), event.getHost(), event.getPort(), event.getConnectionTime());
    }

    @Override
    public void onDisconnect(RedisConnectionEvent event) {
        log.info("Redis连接断开 - 环境: {}, 主机: {}:{}",
                event.getEnvironment(), event.getHost(), event.getPort());
    }

    @Override
    public void onError(RedisErrorEvent event) {
        log.error("Redis错误 - 环境: {}, 类型: {}, 错误码: {}, 消息: {}",
                event.getEnvironment(), event.getErrorType(), event.getErrorCode(), event.getMessage(), event.getThrowable());
    }

    @Override
    public void onReconnecting(RedisReconnectingEvent event) {
        log.info("Redis正在重连 - 环境: {}, 重试次数: {}/{}, 策略: {}",
                event.getEnvironment(), event.getRetryCount(), event.getMaxRetryCount(), event.getRetryStrategy());
    }

    @Override
    public void onEnvironmentChange(RedisEnvironmentChangeEvent event) {
        log.info("Redis环境切换 - 从 {} 切换到 {}, 耗时: {}ms",
                event.getOldEnvironment(), event.getNewEnvironment(), event.getSwitchTime());
    }
}
