package cn.com.anysdk.redis.event;

import cn.com.anysdk.redis.factory.RedisConnectionFactory;
import lombok.Getter;

import java.util.Date;

@Getter
public class RedisConnectionEvent {
    private final RedisConnectionFactory source;
    private final String environment;
    private final String host;
    private final int port;
    private final Date connectionTime;

    public RedisConnectionEvent(RedisConnectionFactory source, String environment, String host, int port, Date connectionTime) {
        this.source = source;
        this.environment = environment;
        this.host = host;
        this.port = port;
        this.connectionTime = connectionTime;
    }
}