package cn.com.anysdk.redis.event;

import cn.com.anysdk.redis.factory.RedisConnectionFactory;
import lombok.Getter;

import java.util.Date;

@Getter
public class RedisEnvironmentChangeEvent {
    private final RedisConnectionFactory source;
    private final String oldEnvironment;
    private final String newEnvironment;
    private final String currentEnvironment;
    private final Date switchTime;

    public RedisEnvironmentChangeEvent(RedisConnectionFactory source, String oldEnvironment, String newEnvironment, String currentEnvironment, Date switchTime) {
        this.source = source;
        this.oldEnvironment = oldEnvironment;
        this.newEnvironment = newEnvironment;
        this.currentEnvironment = currentEnvironment;
        this.switchTime = switchTime;
    }
}