package cn.com.anysdk.redis.event;

import lombok.Data;

/**
 * Redis事件基类
 */
@Data
public abstract class RedisEvent {
    
    /**
     * 事件发生时间
     */
    private final long timestamp;
    
    /**
     * 事件源
     */
    private final Object source;
    
    /**
     * 当前环境
     */
    private final String environment;
    
    public RedisEvent(Object source, String environment) {
        this.timestamp = System.currentTimeMillis();
        this.source = source;
        this.environment = environment;
    }
}