package cn.com.anysdk.redis.event;

/**
 * Redis事件监听器接口
 * 用于监听Redis连接相关事件
 */
public interface RedisEventListener {

    /**
     * 连接成功事件
     *
     * @param event 连接事件信息
     */
    void onConnect(RedisConnectionEvent event);

    /**
     * 连接断开事件
     *
     * @param event 连接事件信息
     */
    void onDisconnect(RedisConnectionEvent event);

    /**
     * 发生错误事件
     *
     * @param event 错误事件信息
     */
    void onError(RedisErrorEvent event);

    /**
     * 正在重连事件
     *
     * @param event 重连事件信息
     */
    void onReconnecting(RedisReconnectingEvent event);

    /**
     * 环境切换事件
     *
     * @param event 环境切换事件信息
     */
    void onEnvironmentChange(RedisEnvironmentChangeEvent event);
}
