package cn.com.anysdk.redis.exception;

/**
 * Redis命令异常
 */
public class RedisCommandException extends RedisException {
    
    private static final String ERROR_CODE_PREFIX = "REDIS_COMMAND_";
    
    public RedisCommandException(String message) {
        super(message, ERROR_CODE_PREFIX + "ERROR");
    }
    
    public RedisCommandException(String message, String errorCode) {
        super(message, ERROR_CODE_PREFIX + errorCode);
    }
    
    public RedisCommandException(String message, Throwable cause) {
        super(message, cause, ERROR_CODE_PREFIX + "ERROR");
    }
    
    public RedisCommandException(String message, Throwable cause, String errorCode) {
        super(message, cause, ERROR_CODE_PREFIX + errorCode);
    }
    
    /**
     * 语法错误异常
     */
    public static class SyntaxException extends RedisCommandException {
        public SyntaxException(String message) {
            super(message, "SYNTAX");
        }
        
        public SyntaxException(String message, Throwable cause) {
            super(message, cause, "SYNTAX");
        }
    }
    
    /**
     * 类型错误异常
     */
    public static class TypeException extends RedisCommandException {
        public TypeException(String message) {
            super(message, "TYPE");
        }
        
        public TypeException(String message, Throwable cause) {
            super(message, cause, "TYPE");
        }
    }
    
    /**
     * 执行错误异常
     */
    public static class ExecutionException extends RedisCommandException {
        public ExecutionException(String message) {
            super(message, "EXECUTION");
        }
        
        public ExecutionException(String message, Throwable cause) {
            super(message, cause, "EXECUTION");
        }
    }
}