package cn.com.anysdk.redis.exception;

/**
 * Redis异常基类
 */
public class RedisException extends RuntimeException {

    /**
     * 错误码
     */
    private final String errorCode;

    public RedisException(String message) {
        this(message, "REDIS_ERROR");
    }

    public RedisException(String message, String errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public RedisException(String message, Throwable cause) {
        this(message, cause, "REDIS_ERROR");
    }

    public RedisException(String message, Throwable cause, String errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    /**
     * 获取错误码
     *
     * @return 错误码
     */
    public String getErrorCode() {
        return errorCode;
    }
}
