package cn.com.anysdk.redis.impl;

import cn.com.anysdk.redis.config.RedisConfigProperties;
import cn.com.anysdk.redis.event.RedisEventManager;
import lombok.extern.slf4j.Slf4j;

/**
 * 本地Redis服务实现类
 * 专门用于本地Redis连接的实现
 */
@Slf4j
public class LocalRedisServiceImpl extends AbstractRedisServiceImpl {

    /**
     * 构造函数
     * @param redisProperties Redis配置属性
     * @param eventManager 事件管理器
     */
    public LocalRedisServiceImpl(RedisConfigProperties redisProperties, RedisEventManager eventManager) {
        super(redisProperties, eventManager);
    }

    @Override
    protected void onInit() {
        log.info("本地Redis服务初始化完成");
    }

    @Override
    protected String getServiceName() {
        return "本地";
    }
}