/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.event;

import cn.com.anysdk.redis.event.RedisConnectionEvent;
import cn.com.anysdk.redis.event.RedisEnvironmentChangeEvent;
import cn.com.anysdk.redis.event.RedisErrorEvent;
import cn.com.anysdk.redis.event.RedisEventListener;
import cn.com.anysdk.redis.event.RedisReconnectingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRedisEventListener
implements RedisEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedisEventListener.class);

    @Override
    public void onConnect(RedisConnectionEvent event) {
        log.info("Redis\u8fde\u63a5\u6210\u529f - \u73af\u5883: {}, \u4e3b\u673a: {}:{}, \u8017\u65f6: {}ms", new Object[]{event.getEnvironment(), event.getHost(), event.getPort(), event.getConnectionTime()});
    }

    @Override
    public void onDisconnect(RedisConnectionEvent event) {
        log.info("Redis\u8fde\u63a5\u65ad\u5f00 - \u73af\u5883: {}, \u4e3b\u673a: {}:{}", new Object[]{event.getEnvironment(), event.getHost(), event.getPort()});
    }

    @Override
    public void onError(RedisErrorEvent event) {
        log.error("Redis\u9519\u8bef - \u73af\u5883: {}, \u7c7b\u578b: {}, \u9519\u8bef\u7801: {}, \u6d88\u606f: {}", new Object[]{event.getEnvironment(), event.getErrorType(), event.getErrorCode(), event.getMessage(), event.getThrowable()});
    }

    @Override
    public void onReconnecting(RedisReconnectingEvent event) {
        log.info("Redis\u6b63\u5728\u91cd\u8fde - \u73af\u5883: {}, \u91cd\u8bd5\u6b21\u6570: {}/{}, \u7b56\u7565: {}", new Object[]{event.getEnvironment(), event.getRetryCount(), event.getMaxRetryCount(), event.getRetryStrategy()});
    }

    @Override
    public void onEnvironmentChange(RedisEnvironmentChangeEvent event) {
        log.info("Redis\u73af\u5883\u5207\u6362 - \u4ece {} \u5207\u6362\u5230 {}, \u8017\u65f6: {}ms", new Object[]{event.getOldEnvironment(), event.getNewEnvironment(), event.getSwitchTime()});
    }
}

