/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.impl;

import cn.com.anysdk.redis.config.RedisConfigProperties;
import cn.com.anysdk.redis.event.RedisEventManager;
import cn.com.anysdk.redis.exception.RedisCommandException;
import cn.com.anysdk.redis.exception.RedisException;
import cn.com.anysdk.redis.impl.AbstractRedisServiceImpl;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class AliyunRedisServiceImpl
extends AbstractRedisServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AliyunRedisServiceImpl.class);
    private JedisCluster jedisCluster;
    private boolean isClusterMode = false;

    public AliyunRedisServiceImpl(RedisConfigProperties redisProperties, RedisEventManager eventManager) {
        super(redisProperties, eventManager);
    }

    @Override
    protected void onInit() {
        this.checkClusterMode();
        log.info("\u963f\u91cc\u4e91Redis\u670d\u52a1\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6a21\u5f0f: {}", (Object)(this.isClusterMode ? "\u96c6\u7fa4" : "\u6807\u51c6"));
    }

    @Override
    protected String getServiceName() {
        return "\u963f\u91cc\u4e91";
    }

    private void checkClusterMode() {
        if (this.redisProperties.getAliyun() != null && "CLUSTER".equalsIgnoreCase(this.redisProperties.getAliyun().getMode())) {
            this.isClusterMode = true;
            try {
                this.jedisCluster = this.connectionFactory.getClusterConnection();
                log.info("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u8fde\u63a5\u5efa\u7acb\u6210\u529f");
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                this.isClusterMode = false;
            }
        } else {
            this.isClusterMode = false;
            this.jedisCluster = null;
            log.info("\u4f7f\u7528\u963f\u91cc\u4e91Redis\u6807\u51c6\u6a21\u5f0f");
        }
    }

    @Override
    protected Jedis getJedis() {
        if (this.isClusterMode) {
            throw new RedisCommandException("\u963f\u91cc\u4e91\u96c6\u7fa4\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301\u83b7\u53d6\u5355\u4e2aJedis\u8fde\u63a5");
        }
        return super.getJedis();
    }

    private <T> T executeClusterCommand(Function<JedisCluster, T> operation) {
        if (!this.isClusterMode || this.jedisCluster == null) {
            throw new RedisCommandException("\u5f53\u524d\u4e0d\u662f\u963f\u91cc\u4e91\u96c6\u7fa4\u6a21\u5f0f\u6216\u96c6\u7fa4\u8fde\u63a5\u672a\u521d\u59cb\u5316");
        }
        try {
            return operation.apply(this.jedisCluster);
        }
        catch (Exception e) {
            try {
                this.exceptionHandler.handleException(e, this, this.redisProperties.getEnvironment());
            }
            catch (RedisException ex) {
                log.error("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u547d\u4ee4\u6267\u884c\u5f02\u5e38", (Throwable)ex);
            }
            throw new RedisCommandException.ExecutionException("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u547d\u4ee4\u6267\u884c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean set(String key, String value) {
        if (this.isClusterMode) {
            return this.executeClusterCommand(cluster -> {
                cluster.set(key, value);
                return true;
            });
        }
        return super.set(key, value);
    }

    @Override
    public String get(String key) {
        if (this.isClusterMode) {
            return this.executeClusterCommand(cluster -> cluster.get(key));
        }
        return super.get(key);
    }

    @Override
    public boolean del(String key) {
        if (this.isClusterMode) {
            return this.executeClusterCommand(cluster -> cluster.del(key) > 0L);
        }
        return super.del(key);
    }

    @Override
    public void multi() {
        if (this.isClusterMode) {
            throw new RedisCommandException("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u6a21\u5f0f\u4e0d\u652f\u6301\u4e8b\u52a1\u64cd\u4f5c");
        }
        super.multi();
    }

    @Override
    public void exec() {
        if (this.isClusterMode) {
            throw new RedisCommandException("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u6a21\u5f0f\u4e0d\u652f\u6301\u4e8b\u52a1\u64cd\u4f5c");
        }
        super.exec();
    }

    @Override
    public void discard() {
        if (this.isClusterMode) {
            throw new RedisCommandException("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u6a21\u5f0f\u4e0d\u652f\u6301\u4e8b\u52a1\u64cd\u4f5c");
        }
        super.discard();
    }

    @Override
    public void pipeline() {
        if (this.isClusterMode) {
            throw new RedisCommandException("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u6a21\u5f0f\u4e0d\u652f\u6301\u7ba1\u9053\u64cd\u4f5c");
        }
        super.pipeline();
    }

    @Override
    public void sync() {
        if (this.isClusterMode) {
            throw new RedisCommandException("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u6a21\u5f0f\u4e0d\u652f\u6301\u7ba1\u9053\u64cd\u4f5c");
        }
        super.sync();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ping() {
        boolean bl;
        Map clusterNodes;
        if (!this.isClusterMode) return super.ping();
        if (this.jedisCluster == null || (clusterNodes = this.jedisCluster.getClusterNodes()) == null || clusterNodes.isEmpty()) return false;
        ConnectionPool pool = (ConnectionPool)clusterNodes.values().iterator().next();
        Connection conn = pool.getResource();
        try {
            bl = "PONG".equals(conn.ping());
            if (conn == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("\u963f\u91cc\u4e91Redis\u96c6\u7fa4ping\u5931\u8d25", (Throwable)e);
                return false;
            }
        }
        conn.close();
        return bl;
    }

    @Override
    public void close() {
        if (this.jedisCluster != null) {
            try {
                this.jedisCluster.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
            finally {
                this.jedisCluster = null;
            }
        }
        super.close();
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.close();
        if (this.connectionFactory != null) {
            this.connectionFactory.close();
        }
    }
}

