/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.reconnect;

import cn.com.anysdk.redis.event.RedisEventManager;
import cn.com.anysdk.redis.event.RedisReconnectingEvent;
import cn.com.anysdk.redis.exception.RedisConnectionException;
import cn.com.anysdk.redis.reconnect.ExponentialBackoffReconnectStrategy;
import cn.com.anysdk.redis.reconnect.RedisReconnectStrategy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisReconnectManager {
    private static final Logger log = LoggerFactory.getLogger(RedisReconnectManager.class);
    private final RedisEventManager eventManager;
    private final RedisReconnectStrategy reconnectStrategy;
    private final ScheduledExecutorService scheduler;
    private final AtomicInteger retryCount;
    private final AtomicBoolean reconnecting;
    private ScheduledFuture<?> reconnectTask;

    public RedisReconnectManager(RedisEventManager eventManager, RedisReconnectStrategy reconnectStrategy) {
        this.eventManager = eventManager;
        this.reconnectStrategy = reconnectStrategy;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "redis-reconnect-thread");
            thread.setDaemon(true);
            return thread;
        });
        this.retryCount = new AtomicInteger(0);
        this.reconnecting = new AtomicBoolean(false);
    }

    public void startReconnect(Object source, String environment, Supplier<Boolean> reconnectAction) {
        if (this.reconnecting.compareAndSet(false, true)) {
            log.info("\u5f00\u59cbRedis\u91cd\u8fde\uff0c\u4f7f\u7528\u7b56\u7565: {}", (Object)this.reconnectStrategy.getName());
            this.retryCount.set(0);
            this.scheduleReconnect(source, environment, reconnectAction);
        } else {
            log.debug("Redis\u91cd\u8fde\u5df2\u5728\u8fdb\u884c\u4e2d\uff0c\u5ffd\u7565\u6b64\u6b21\u91cd\u8fde\u8bf7\u6c42");
        }
    }

    public void stopReconnect() {
        if (this.reconnecting.compareAndSet(true, false)) {
            if (this.reconnectTask != null && !this.reconnectTask.isDone()) {
                this.reconnectTask.cancel(false);
                this.reconnectTask = null;
            }
            log.info("Redis\u91cd\u8fde\u5df2\u505c\u6b62");
        }
    }

    public void reset() {
        this.stopReconnect();
        this.retryCount.set(0);
        this.reconnectStrategy.reset();
    }

    public void shutdown() {
        this.stopReconnect();
        this.scheduler.shutdownNow();
    }

    private void scheduleReconnect(Object source, String environment, Supplier<Boolean> reconnectAction) {
        int currentRetryCount = this.retryCount.get();
        int maxRetryCount = this.reconnectStrategy.getMaxRetryCount();
        if (maxRetryCount != -1 && currentRetryCount >= maxRetryCount) {
            log.error("Redis\u91cd\u8fde\u5931\u8d25\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570: {}", (Object)maxRetryCount);
            this.reconnecting.set(false);
            throw new RedisConnectionException.NetworkException("Redis\u91cd\u8fde\u5931\u8d25\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570: " + maxRetryCount);
        }
        long waitTimeMs = this.reconnectStrategy.getNextWaitTime(currentRetryCount);
        this.eventManager.fireReconnectingEvent(new RedisReconnectingEvent(source, environment, currentRetryCount, maxRetryCount, waitTimeMs, this.reconnectStrategy instanceof ExponentialBackoffReconnectStrategy ? RedisReconnectingEvent.RetryStrategy.EXPONENTIAL_BACKOFF : RedisReconnectingEvent.RetryStrategy.FIXED_INTERVAL));
        this.reconnectTask = this.scheduler.schedule(() -> {
            try {
                log.info("\u6267\u884c\u7b2c{}\u6b21Redis\u91cd\u8fde\u5c1d\u8bd5...", (Object)(currentRetryCount + 1));
                boolean success = (Boolean)reconnectAction.get();
                if (success) {
                    log.info("Redis\u91cd\u8fde\u6210\u529f");
                    this.reconnecting.set(false);
                } else {
                    log.warn("Redis\u91cd\u8fde\u5c1d\u8bd5\u5931\u8d25\uff0c\u5c06\u7ee7\u7eed\u91cd\u8bd5");
                    this.retryCount.incrementAndGet();
                    this.scheduleReconnect(source, environment, reconnectAction);
                }
            }
            catch (Exception e) {
                log.error("Redis\u91cd\u8fde\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                this.retryCount.incrementAndGet();
                this.scheduleReconnect(source, environment, reconnectAction);
            }
        }, waitTimeMs, TimeUnit.MILLISECONDS);
    }
}

