package cn.com.anysdk.redis.api;

import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IRedisService {
    // String 操作
    boolean set(String key, String value);
    boolean setEx(String key, String value, long expireSeconds);
    String get(String key);
    boolean del(String key);
    boolean exists(String key);
    long expire(String key, long seconds);
    long ttl(String key);

    // Hash 操作
    boolean hSet(String key, String field, String value);
    String hGet(String key, String field);
    Map<String, String> hGetAll(String key);
    long hDel(String key, String... fields);
    boolean hExists(String key, String field);
    long hLen(String key);
    Set<String> hKeys(String key);
    List<String> hVals(String key);

    // List 操作
    long lPush(String key, String... values);
    long rPush(String key, String... values);
    String lPop(String key);
    String rPop(String key);
    long lLen(String key);
    List<String> lRange(String key, long start, long end);
    String lIndex(String key, long index);
    boolean lSet(String key, long index, String value);
    long lRem(String key, long count, String value);

    // Set 操作
    long sAdd(String key, String... members);
    long sRem(String key, String... members);
    boolean sIsMember(String key, String member);
    Set<String> sMembers(String key);
    long sCard(String key);
    Set<String> sInter(String... keys);
    Set<String> sUnion(String... keys);
    Set<String> sDiff(String... keys);

    // ZSet 操作
    long zAdd(String key, double score, String member);
    long zRem(String key, String... members);
    double zScore(String key, String member);
    long zCard(String key);
    Set<String> zRange(String key, long start, long end);
    Set<String> zRevRange(String key, long start, long end);
    Set<String> zRangeByScore(String key, double min, double max);
    Set<String> zRevRangeByScore(String key, double max, double min);

    // 事务操作
    void multi();
    void exec();
    void discard();

    // 管道操作
    void pipeline();
    void sync();

    // Lua脚本
    Object eval(String script, List<String> keys, List<String> args);

    // 键管理
    Set<String> keys(String pattern);
    String type(String key);
    long memoryUsage(String key);

    // 数据库管理
    boolean flushAll();
    boolean flushDB();

    // 连接管理
    boolean ping();
    void close();
}