package cn.com.anysdk.redis.config;

import cn.com.anysdk.redis.api.IRedisConfig;
import lombok.Data;

/**
 * 阿里云Redis配置
 * 支持标准主从、集群版、哨兵模式
 */
@Data
public class AliyunRedisConfig implements IRedisConfig {

    private String endpoint;
    private int port = 6379;
    private String accessKeyId;
    private String accessKeySecret;
    private String securityToken;
    private String password;
    private int database = 0;
    private String mode = "standard"; // standard, cluster, sentinel

    // VPC网络配置
    private String vpcId;
    private String instanceId;
    private String connectionDomain;

    // 集群节点信息
    private String[] clusterNodes;
    private int maxRedirects = 3;

    // 哨兵配置
    private String masterName;
    private String[] sentinelNodes;

    @Override
    public String getHost() {
        return endpoint;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public String getPassword() {
        return password;
    }

    @Override
    public int getDatabase() {
        return database;
    }
}