package cn.com.anysdk.redis.config;

import cn.com.anysdk.redis.api.IRedisConfig;
import lombok.Data;

/**
 * 华为云Redis配置
 * 支持单机版、主备版、集群版、读写分离版
 */
@Data
public class HuaweiRedisConfig implements IRedisConfig {

    private String endpoint;
    private int port = 6379;
    private String accessKey;
    private String secretKey;
    private String securityToken;
    private String password;
    private int database = 0;
    private String mode = "single"; // single, master-standby, cluster, proxy-cluster

    // 华为云特有配置
    private String region;
    private String projectId;
    private String instanceId;
    private String vpcId;
    private String subnetId;
    private String securityGroupId;

    // 集群节点信息
    private String[] clusterNodes;
    private int maxRedirects = 3;

    // 读写分离配置
    private String[] readOnlyNodes;
    private boolean enableReadWriteSplit = false;

    @Override
    public String getHost() {
        return endpoint;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public String getPassword() {
        return password;
    }

    @Override
    public int getDatabase() {
        return database;
    }
}