package cn.com.anysdk.redis.config;

import lombok.Data;

/**
 * Redis配置属性类
 * 核心库配置，可以独立使用或配合Spring Boot
 */
@Data
public class RedisConfigProperties {
    private String environment = "local";
    private LocalConfig local = new LocalConfig();
    private AliyunConfig aliyun = new AliyunConfig();
    private HuaweiRedisConfig huawei = new HuaweiRedisConfig();
    private TencentRedisConfig tencent = new TencentRedisConfig();

    @Data
    public static class LocalConfig {
        private String host = "localhost";
        private int port = 6379;
        private String password;
        private int database = 0;
        private PoolConfig pool = new PoolConfig();
        private TimeoutConfig timeout = new TimeoutConfig();
    }

    @Data
    public static class AliyunConfig {
        private String mode = "STANDARD";
        private PoolConfig pool = new PoolConfig();
        private TimeoutConfig timeout = new TimeoutConfig();
        private AliyunRedisConfig config;
    }

    @Data
    public static class PoolConfig {
        private int maxTotal = 8;
        private int maxIdle = 8;
        private int minIdle = 0;
        private long maxWaitMillis = -1L;
        private boolean testOnBorrow = true;
        private boolean testOnReturn = false;
        private boolean testWhileIdle = true;
        private long timeBetweenEvictionRunsMillis = 30000L;
        private int numTestsPerEvictionRun = 3;
        private long minEvictableIdleTimeMillis = 1800000L;
        private boolean preWarm = false;
    }

    @Data
    public static class TimeoutConfig {
        private int connectionTimeout = 2000;
        private int soTimeout = 2000;
        private int maxAttempts = 3;
    }
}