package cn.com.anysdk.redis.event;

import lombok.Getter;

/**
 * Redis错误事件
 */
@Getter
public class RedisErrorEvent extends RedisEvent {

    /**
     * 错误类型
     */
    private final ErrorType errorType;

    /**
     * 错误消息
     */
    private final String message;

    /**
     * 异常对象
     */
    private final Throwable throwable;

    /**
     * 错误码
     */
    private final String errorCode;

    public RedisErrorEvent(Object source, String environment, ErrorType errorType,
                          String message, Throwable throwable, String errorCode) {
        super(source, environment);
        this.errorType = errorType;
        this.message = message;
        this.throwable = throwable;
        this.errorCode = errorCode;
    }

    /**
     * 错误类型枚举
     */
    public enum ErrorType {
        /**
         * 连接错误
         */
        CONNECTION_ERROR,

        /**
         * 命令错误
         */
        COMMAND_ERROR,

        /**
         * 环境错误
         */
        ENVIRONMENT_ERROR,

        /**
         * 阿里云特有错误
         */
        ALIYUN_ERROR,

        /**
         * 未知错误
         */
        UNKNOWN_ERROR
    }
}
