package cn.com.anysdk.redis.event;

import lombok.Getter;

/**
 * Redis重连事件
 */
@Getter
public class RedisReconnectingEvent extends RedisEvent {

    /**
     * 重连次数
     */
    private final int retryCount;

    /**
     * 最大重连次数
     */
    private final int maxRetryCount;

    /**
     * 重连间隔(毫秒)
     */
    private final long retryInterval;

    /**
     * 重连策略
     */
    private final RetryStrategy retryStrategy;

    public RedisReconnectingEvent(Object source, String environment, int retryCount,
                                 int maxRetryCount, long retryInterval, RetryStrategy retryStrategy) {
        super(source, environment);
        this.retryCount = retryCount;
        this.maxRetryCount = maxRetryCount;
        this.retryInterval = retryInterval;
        this.retryStrategy = retryStrategy;
    }

    /**
     * 重连策略枚举
     */
    public enum RetryStrategy {
        /**
         * 固定间隔
         */
        FIXED_INTERVAL,

        /**
         * 指数退避
         */
        EXPONENTIAL_BACKOFF
    }
}
