package cn.com.anysdk.redis.reconnect;

/**
 * 固定间隔重连策略
 */
public class FixedIntervalReconnectStrategy implements RedisReconnectStrategy {

    private final long intervalMs;
    private final int maxRetryCount;

    /**
     * 创建固定间隔重连策略
     *
     * @param intervalMs 重连间隔（毫秒）
     * @param maxRetryCount 最大重试次数，-1表示无限重试
     */
    public FixedIntervalReconnectStrategy(long intervalMs, int maxRetryCount) {
        this.intervalMs = intervalMs;
        this.maxRetryCount = maxRetryCount;
    }

    @Override
    public long getNextWaitTime(int retryCount) {
        return intervalMs;
    }

    @Override
    public int getMaxRetryCount() {
        return maxRetryCount;
    }

    @Override
    public void reset() {
        // 固定间隔策略无需重置状态
    }

    @Override
    public String getName() {
        return "固定间隔策略";
    }
}
