package cn.com.anysdk.redis.reconnect;

/**
 * Redis重连策略接口
 */
public interface RedisReconnectStrategy {

    /**
     * 获取下一次重连的等待时间（毫秒）
     *
     * @param retryCount 当前重试次数
     * @return 等待时间（毫秒）
     */
    long getNextWaitTime(int retryCount);

    /**
     * 获取最大重试次数
     *
     * @return 最大重试次数，-1表示无限重试
     */
    int getMaxRetryCount();

    /**
     * 重置重连策略状态
     */
    void reset();

    /**
     * 获取策略名称
     *
     * @return 策略名称
     */
    String getName();
}
