/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.event;

import cn.com.anysdk.redis.event.RedisConnectionEvent;
import cn.com.anysdk.redis.event.RedisEnvironmentChangeEvent;
import cn.com.anysdk.redis.event.RedisErrorEvent;
import cn.com.anysdk.redis.event.RedisEventListener;
import cn.com.anysdk.redis.event.RedisReconnectingEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisEventManager {
    private static final Logger log = LoggerFactory.getLogger(RedisEventManager.class);
    private final List<RedisEventListener> listeners = new CopyOnWriteArrayList<RedisEventListener>();

    public void registerListener(RedisEventListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
            log.debug("\u6ce8\u518cRedis\u4e8b\u4ef6\u76d1\u542c\u5668: {}", (Object)listener.getClass().getName());
        }
    }

    public void removeListener(RedisEventListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
            log.debug("\u79fb\u9664Redis\u4e8b\u4ef6\u76d1\u542c\u5668: {}", (Object)listener.getClass().getName());
        }
    }

    public void fireConnectEvent(RedisConnectionEvent event) {
        for (RedisEventListener listener : this.listeners) {
            try {
                listener.onConnect(event);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u8fde\u63a5\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void fireDisconnectEvent(RedisConnectionEvent event) {
        for (RedisEventListener listener : this.listeners) {
            try {
                listener.onDisconnect(event);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u65ad\u5f00\u8fde\u63a5\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void fireErrorEvent(RedisErrorEvent event) {
        for (RedisEventListener listener : this.listeners) {
            try {
                listener.onError(event);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u9519\u8bef\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void fireReconnectingEvent(RedisReconnectingEvent event) {
        for (RedisEventListener listener : this.listeners) {
            try {
                listener.onReconnecting(event);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u91cd\u8fde\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void fireEnvironmentChangeEvent(RedisEnvironmentChangeEvent event) {
        for (RedisEventListener listener : this.listeners) {
            try {
                listener.onEnvironmentChange(event);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u73af\u5883\u5207\u6362\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

