/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.exception;

import cn.com.anysdk.redis.exception.RedisException;

public class AliyunRedisException
extends RedisException {
    private static final String ERROR_CODE_PREFIX = "ALIYUN_REDIS_";

    public AliyunRedisException(String message) {
        super(message, "ALIYUN_REDIS_ERROR");
    }

    public AliyunRedisException(String message, String errorCode) {
        super(message, ERROR_CODE_PREFIX + errorCode);
    }

    public AliyunRedisException(String message, Throwable cause) {
        super(message, cause, "ALIYUN_REDIS_ERROR");
    }

    public AliyunRedisException(String message, Throwable cause, String errorCode) {
        super(message, cause, ERROR_CODE_PREFIX + errorCode);
    }

    public static class VpcNetworkException
    extends AliyunRedisException {
        public VpcNetworkException(String message) {
            super(message, "VPC_NETWORK");
        }

        public VpcNetworkException(String message, Throwable cause) {
            super(message, cause, "VPC_NETWORK");
        }
    }

    public static class InstanceNotFoundException
    extends AliyunRedisException {
        public InstanceNotFoundException(String message) {
            super(message, "INSTANCE_NOT_FOUND");
        }

        public InstanceNotFoundException(String message, Throwable cause) {
            super(message, cause, "INSTANCE_NOT_FOUND");
        }
    }

    public static class PermissionDeniedException
    extends AliyunRedisException {
        public PermissionDeniedException(String message) {
            super(message, "PERMISSION_DENIED");
        }

        public PermissionDeniedException(String message, Throwable cause) {
            super(message, cause, "PERMISSION_DENIED");
        }
    }

    public static class QuotaLimitException
    extends AliyunRedisException {
        public QuotaLimitException(String message) {
            super(message, "QUOTA_LIMIT");
        }

        public QuotaLimitException(String message, Throwable cause) {
            super(message, cause, "QUOTA_LIMIT");
        }
    }
}

