/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.exception;

import cn.com.anysdk.redis.event.RedisErrorEvent;
import cn.com.anysdk.redis.event.RedisEventManager;
import cn.com.anysdk.redis.exception.AliyunRedisException;
import cn.com.anysdk.redis.exception.RedisCommandException;
import cn.com.anysdk.redis.exception.RedisConnectionException;
import cn.com.anysdk.redis.exception.RedisEnvironmentException;
import cn.com.anysdk.redis.exception.RedisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RedisExceptionHandler.class);
    private final RedisEventManager eventManager;

    public RedisExceptionHandler(RedisEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void handleException(Throwable e, Object source, String environment) throws RedisException {
        RedisException redisException = this.convertException(e);
        RedisErrorEvent.ErrorType errorType = this.determineErrorType(redisException);
        RedisErrorEvent errorEvent = new RedisErrorEvent(source, environment, errorType, redisException.getMessage(), redisException, redisException.getErrorCode());
        this.eventManager.fireErrorEvent(errorEvent);
        if (this.shouldRethrow(errorType)) {
            throw redisException;
        }
    }

    private RedisException convertException(Throwable e) {
        if (e instanceof RedisException) {
            return (RedisException)e;
        }
        String message = e.getMessage();
        if (message == null) {
            message = e.getClass().getName();
        }
        if (message.contains("connection") || message.contains("timeout") || message.contains("network") || message.contains("refused")) {
            if (message.contains("timeout")) {
                return new RedisConnectionException.TimeoutException("\u8fde\u63a5\u8d85\u65f6: " + message, e);
            }
            if (message.contains("auth") || message.contains("password")) {
                return new RedisConnectionException.AuthenticationException("\u8ba4\u8bc1\u5931\u8d25: " + message, e);
            }
            return new RedisConnectionException.NetworkException("\u7f51\u7edc\u5f02\u5e38: " + message, e);
        }
        if (message.contains("command") || message.contains("syntax") || message.contains("argument") || message.contains("type")) {
            if (message.contains("syntax")) {
                return new RedisCommandException.SyntaxException("\u547d\u4ee4\u8bed\u6cd5\u9519\u8bef: " + message, e);
            }
            if (message.contains("type")) {
                return new RedisCommandException.TypeException("\u547d\u4ee4\u7c7b\u578b\u9519\u8bef: " + message, e);
            }
            return new RedisCommandException.ExecutionException("\u547d\u4ee4\u6267\u884c\u9519\u8bef: " + message, e);
        }
        if (message.contains("Aliyun") || message.contains("aliyun") || message.contains("quota") || message.contains("permission")) {
            if (message.contains("quota")) {
                return new AliyunRedisException.QuotaLimitException("\u963f\u91cc\u4e91\u914d\u989d\u9650\u5236: " + message, e);
            }
            if (message.contains("permission") || message.contains("denied")) {
                return new AliyunRedisException.PermissionDeniedException("\u963f\u91cc\u4e91\u6743\u9650\u4e0d\u8db3: " + message, e);
            }
            if (message.contains("instance") && message.contains("not found")) {
                return new AliyunRedisException.InstanceNotFoundException("\u963f\u91cc\u4e91\u5b9e\u4f8b\u4e0d\u5b58\u5728: " + message, e);
            }
            if (message.contains("VPC") || message.contains("vpc")) {
                return new AliyunRedisException.VpcNetworkException("\u963f\u91cc\u4e91VPC\u7f51\u7edc\u5f02\u5e38: " + message, e);
            }
            return new AliyunRedisException("\u963f\u91cc\u4e91Redis\u5f02\u5e38: " + message, e);
        }
        if (message.contains("environment") || message.contains("config")) {
            if (message.contains("missing") || message.contains("not found")) {
                return new RedisEnvironmentException.ConfigMissingException("\u914d\u7f6e\u7f3a\u5931: " + message, e);
            }
            if (message.contains("undefined")) {
                return new RedisEnvironmentException.UndefinedEnvironmentException("\u73af\u5883\u672a\u5b9a\u4e49: " + message, e);
            }
            if (message.contains("switch")) {
                return new RedisEnvironmentException.SwitchException("\u73af\u5883\u5207\u6362\u5931\u8d25: " + message, e);
            }
            return new RedisEnvironmentException("\u73af\u5883\u5f02\u5e38: " + message, e);
        }
        return new RedisException("Redis\u5f02\u5e38: " + message, e);
    }

    private RedisErrorEvent.ErrorType determineErrorType(RedisException e) {
        if (e instanceof RedisConnectionException) {
            return RedisErrorEvent.ErrorType.CONNECTION_ERROR;
        }
        if (e instanceof RedisCommandException) {
            return RedisErrorEvent.ErrorType.COMMAND_ERROR;
        }
        if (e instanceof RedisEnvironmentException) {
            return RedisErrorEvent.ErrorType.ENVIRONMENT_ERROR;
        }
        if (e instanceof AliyunRedisException) {
            return RedisErrorEvent.ErrorType.ALIYUN_ERROR;
        }
        return RedisErrorEvent.ErrorType.UNKNOWN_ERROR;
    }

    private boolean shouldRethrow(RedisErrorEvent.ErrorType errorType) {
        return errorType != RedisErrorEvent.ErrorType.CONNECTION_ERROR;
    }
}

