/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.factory;

import cn.com.anysdk.redis.api.IRedisService;
import cn.com.anysdk.redis.config.RedisConfigProperties;
import cn.com.anysdk.redis.event.RedisEventManager;
import cn.com.anysdk.redis.impl.AliyunRedisServiceImpl;
import cn.com.anysdk.redis.impl.LocalRedisServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceFactory.class);

    public static IRedisService createRedisService(RedisConfigProperties redisProperties, RedisEventManager eventManager) {
        String environment = redisProperties.getEnvironment();
        log.info("\u521b\u5efaRedis\u670d\u52a1\u5b9e\u4f8b\uff0c\u73af\u5883: {}", (Object)environment);
        switch (environment.toLowerCase()) {
            case "local": {
                return new LocalRedisServiceImpl(redisProperties, eventManager);
            }
            case "aliyun": {
                return new AliyunRedisServiceImpl(redisProperties, eventManager);
            }
            case "huawei": {
                throw new UnsupportedOperationException("\u534e\u4e3a\u4e91Redis\u670d\u52a1\u6682\u672a\u5b9e\u73b0");
            }
            case "tencent": {
                throw new UnsupportedOperationException("\u817e\u8baf\u4e91Redis\u670d\u52a1\u6682\u672a\u5b9e\u73b0");
            }
        }
        log.warn("\u672a\u77e5\u7684Redis\u73af\u5883: {}\uff0c\u4f7f\u7528\u672c\u5730\u73af\u5883", (Object)environment);
        return new LocalRedisServiceImpl(redisProperties, eventManager);
    }

    public static boolean isSupportedEnvironment(String environment) {
        switch (environment.toLowerCase()) {
            case "local": 
            case "aliyun": {
                return true;
            }
            case "huawei": 
            case "tencent": {
                return false;
            }
        }
        return false;
    }
}

