/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.reconnect;

import cn.com.anysdk.redis.reconnect.RedisReconnectStrategy;

public class ExponentialBackoffReconnectStrategy
implements RedisReconnectStrategy {
    private final long initialIntervalMs;
    private final long maxIntervalMs;
    private final double multiplier;
    private final int maxRetryCount;

    public ExponentialBackoffReconnectStrategy(long initialIntervalMs, long maxIntervalMs, double multiplier, int maxRetryCount) {
        this.initialIntervalMs = initialIntervalMs;
        this.maxIntervalMs = maxIntervalMs;
        this.multiplier = multiplier;
        this.maxRetryCount = maxRetryCount;
    }

    @Override
    public long getNextWaitTime(int retryCount) {
        double waitTime = (double)this.initialIntervalMs * Math.pow(this.multiplier, retryCount);
        return Math.min((long)waitTime, this.maxIntervalMs);
    }

    @Override
    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @Override
    public void reset() {
    }

    @Override
    public String getName() {
        return "\u6307\u6570\u9000\u907f\u7b56\u7565";
    }
}

