/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.impl;

import cn.com.anysdk.redis.api.IRedisService;
import cn.com.anysdk.redis.config.RedisConfigProperties;
import cn.com.anysdk.redis.event.RedisEventManager;
import cn.com.anysdk.redis.exception.RedisCommandException;
import cn.com.anysdk.redis.exception.RedisConnectionException;
import cn.com.anysdk.redis.exception.RedisException;
import cn.com.anysdk.redis.exception.RedisExceptionHandler;
import cn.com.anysdk.redis.factory.RedisConnectionFactory;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Transaction;

public abstract class AbstractRedisServiceImpl
implements IRedisService {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisServiceImpl.class);
    protected RedisConfigProperties redisProperties;
    protected RedisEventManager eventManager;
    protected RedisConnectionFactory connectionFactory;
    protected RedisExceptionHandler exceptionHandler;
    protected Jedis jedis;
    protected Pipeline pipeline;
    protected Transaction transaction;

    public AbstractRedisServiceImpl(RedisConfigProperties redisProperties, RedisEventManager eventManager) {
        this.redisProperties = redisProperties;
        this.eventManager = eventManager;
        this.init();
    }

    @PostConstruct
    public void init() {
        this.exceptionHandler = new RedisExceptionHandler(this.eventManager);
        this.connectionFactory = new RedisConnectionFactory(this.redisProperties, this.eventManager);
        this.onInit();
    }

    protected abstract void onInit();

    protected abstract String getServiceName();

    protected Jedis getJedis() {
        if (this.jedis == null) {
            this.jedis = this.connectionFactory.getConnection();
        }
        return this.jedis;
    }

    protected <T> T executeCommand(Function<Jedis, T> operation) {
        try {
            return operation.apply(this.getJedis());
        }
        catch (Exception e) {
            block4: {
                try {
                    this.exceptionHandler.handleException(e, this, this.redisProperties.getEnvironment());
                }
                catch (RedisException ex) {
                    log.error("{}Redis\u547d\u4ee4\u6267\u884c\u5f02\u5e38", (Object)this.getServiceName(), (Object)ex);
                    if (!(ex instanceof RedisConnectionException)) break block4;
                    this.jedis = null;
                }
            }
            throw new RedisCommandException.ExecutionException(this.getServiceName() + "Redis\u547d\u4ee4\u6267\u884c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean set(String key, String value) {
        return this.executeCommand(jedis -> {
            jedis.set(key, value);
            return true;
        });
    }

    @Override
    public boolean setEx(String key, String value, long expireSeconds) {
        return this.executeCommand(jedis -> {
            jedis.setex(key, expireSeconds, value);
            return true;
        });
    }

    @Override
    public String get(String key) {
        return this.executeCommand(jedis -> jedis.get(key));
    }

    @Override
    public boolean del(String key) {
        return this.executeCommand(jedis -> jedis.del(key) > 0L);
    }

    @Override
    public boolean exists(String key) {
        return this.executeCommand(jedis -> jedis.exists(key));
    }

    @Override
    public long expire(String key, long seconds) {
        return this.executeCommand(jedis -> jedis.expire(key, seconds));
    }

    @Override
    public long ttl(String key) {
        return this.executeCommand(jedis -> jedis.ttl(key));
    }

    @Override
    public boolean hSet(String key, String field, String value) {
        return this.executeCommand(jedis -> jedis.hset(key, field, value) > 0L);
    }

    @Override
    public String hGet(String key, String field) {
        return this.executeCommand(jedis -> jedis.hget(key, field));
    }

    @Override
    public Map<String, String> hGetAll(String key) {
        return this.executeCommand(jedis -> jedis.hgetAll(key));
    }

    @Override
    public long hDel(String key, String ... fields) {
        return this.executeCommand(jedis -> jedis.hdel(key, fields));
    }

    @Override
    public boolean hExists(String key, String field) {
        return this.executeCommand(jedis -> jedis.hexists(key, field));
    }

    @Override
    public long hLen(String key) {
        return this.executeCommand(jedis -> jedis.hlen(key));
    }

    @Override
    public Set<String> hKeys(String key) {
        return this.executeCommand(jedis -> jedis.hkeys(key));
    }

    @Override
    public List<String> hVals(String key) {
        return this.executeCommand(jedis -> jedis.hvals(key));
    }

    @Override
    public long lPush(String key, String ... values) {
        return this.executeCommand(jedis -> jedis.lpush(key, values));
    }

    @Override
    public long rPush(String key, String ... values) {
        return this.executeCommand(jedis -> jedis.rpush(key, values));
    }

    @Override
    public String lPop(String key) {
        return this.executeCommand(jedis -> jedis.lpop(key));
    }

    @Override
    public String rPop(String key) {
        return this.executeCommand(jedis -> jedis.rpop(key));
    }

    @Override
    public long lLen(String key) {
        return this.executeCommand(jedis -> jedis.llen(key));
    }

    @Override
    public List<String> lRange(String key, long start, long end) {
        return this.executeCommand(jedis -> jedis.lrange(key, start, end));
    }

    @Override
    public String lIndex(String key, long index) {
        return this.executeCommand(jedis -> jedis.lindex(key, index));
    }

    @Override
    public boolean lSet(String key, long index, String value) {
        return this.executeCommand(jedis -> {
            jedis.lset(key, index, value);
            return true;
        });
    }

    @Override
    public long lRem(String key, long count, String value) {
        return this.executeCommand(jedis -> jedis.lrem(key, count, value));
    }

    @Override
    public long sAdd(String key, String ... members) {
        return this.executeCommand(jedis -> jedis.sadd(key, members));
    }

    @Override
    public long sRem(String key, String ... members) {
        return this.executeCommand(jedis -> jedis.srem(key, members));
    }

    @Override
    public boolean sIsMember(String key, String member) {
        return this.executeCommand(jedis -> jedis.sismember(key, member));
    }

    @Override
    public Set<String> sMembers(String key) {
        return this.executeCommand(jedis -> jedis.smembers(key));
    }

    @Override
    public long sCard(String key) {
        return this.executeCommand(jedis -> jedis.scard(key));
    }

    @Override
    public Set<String> sInter(String ... keys) {
        return this.executeCommand(jedis -> jedis.sinter(keys));
    }

    @Override
    public Set<String> sUnion(String ... keys) {
        return this.executeCommand(jedis -> jedis.sunion(keys));
    }

    @Override
    public Set<String> sDiff(String ... keys) {
        return this.executeCommand(jedis -> jedis.sdiff(keys));
    }

    @Override
    public long zAdd(String key, double score, String member) {
        return this.executeCommand(jedis -> jedis.zadd(key, score, member));
    }

    @Override
    public long zRem(String key, String ... members) {
        return this.executeCommand(jedis -> jedis.zrem(key, members));
    }

    @Override
    public double zScore(String key, String member) {
        return this.executeCommand(jedis -> {
            Double score = jedis.zscore(key, member);
            return score != null ? score : 0.0;
        });
    }

    @Override
    public long zCard(String key) {
        return this.executeCommand(jedis -> jedis.zcard(key));
    }

    @Override
    public Set<String> zRange(String key, long start, long end) {
        return this.executeCommand(jedis -> new HashSet(jedis.zrange(key, start, end)));
    }

    @Override
    public Set<String> zRevRange(String key, long start, long end) {
        return this.executeCommand(jedis -> new HashSet(jedis.zrevrange(key, start, end)));
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max) {
        return this.executeCommand(jedis -> new HashSet(jedis.zrangeByScore(key, min, max)));
    }

    @Override
    public Set<String> zRevRangeByScore(String key, double max, double min) {
        return this.executeCommand(jedis -> new HashSet(jedis.zrevrangeByScore(key, max, min)));
    }

    @Override
    public void multi() {
        try {
            this.transaction = this.getJedis().multi();
        }
        catch (Exception e) {
            log.error("\u5f00\u542f{}\u4e8b\u52a1\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            throw new RedisCommandException.ExecutionException("\u5f00\u542f\u4e8b\u52a1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void exec() {
        if (this.transaction == null) {
            throw new RedisCommandException("\u4e8b\u52a1\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u6267\u884c");
        }
        try {
            this.transaction.exec();
            this.transaction = null;
        }
        catch (Exception e) {
            log.error("\u6267\u884c{}\u4e8b\u52a1\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            this.transaction = null;
            throw new RedisCommandException.ExecutionException("\u6267\u884c\u4e8b\u52a1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void discard() {
        if (this.transaction == null) {
            throw new RedisCommandException("\u4e8b\u52a1\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u53d6\u6d88");
        }
        try {
            this.transaction.discard();
            this.transaction = null;
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88{}\u4e8b\u52a1\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            this.transaction = null;
            throw new RedisCommandException.ExecutionException("\u53d6\u6d88\u4e8b\u52a1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void pipeline() {
        try {
            this.pipeline = this.getJedis().pipelined();
        }
        catch (Exception e) {
            log.error("\u5f00\u542f{}\u7ba1\u9053\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            throw new RedisCommandException.ExecutionException("\u5f00\u542f\u7ba1\u9053\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public void sync() {
        if (this.pipeline == null) {
            throw new RedisCommandException("\u7ba1\u9053\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u540c\u6b65");
        }
        try {
            this.pipeline.sync();
            this.pipeline = null;
        }
        catch (Exception e) {
            log.error("\u540c\u6b65{}\u7ba1\u9053\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            this.pipeline = null;
            throw new RedisCommandException.ExecutionException("\u540c\u6b65\u7ba1\u9053\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        return this.executeCommand(jedis -> jedis.eval(script, keys, args));
    }

    @Override
    public boolean ping() {
        try {
            return "PONG".equals(this.getJedis().ping());
        }
        catch (Exception e) {
            log.error("{}Redis ping\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            this.jedis = null;
            return false;
        }
    }

    @Override
    public void close() {
        if (this.jedis != null) {
            try {
                this.jedis.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed{}Redis\u8fde\u63a5\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            }
            finally {
                this.jedis = null;
            }
        }
        if (this.pipeline != null) {
            try {
                this.pipeline.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed{}Redis\u7ba1\u9053\u5931\u8d25", (Object)this.getServiceName(), (Object)e);
            }
            finally {
                this.pipeline = null;
            }
        }
        this.transaction = null;
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.executeCommand(jedis -> jedis.keys(pattern));
    }

    @Override
    public String type(String key) {
        return this.executeCommand(jedis -> jedis.type(key));
    }

    @Override
    public long memoryUsage(String key) {
        return this.executeCommand(jedis -> {
            Long usage = jedis.memoryUsage(key);
            return usage != null ? usage : 0L;
        });
    }

    @Override
    public boolean flushAll() {
        return this.executeCommand(jedis -> {
            String result = jedis.flushAll();
            return "OK".equals(result);
        });
    }

    @Override
    public boolean flushDB() {
        return this.executeCommand(jedis -> {
            String result = jedis.flushDB();
            return "OK".equals(result);
        });
    }

    @PreDestroy
    public void destroy() {
        this.close();
        if (this.connectionFactory != null) {
            this.connectionFactory.close();
        }
    }
}

