/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.redis.impl;

import cn.com.anysdk.redis.config.RedisConfigProperties;
import cn.com.anysdk.redis.event.RedisEventManager;
import cn.com.anysdk.redis.exception.RedisCommandException;
import cn.com.anysdk.redis.exception.RedisException;
import cn.com.anysdk.redis.impl.AbstractRedisServiceImpl;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class AliyunRedisServiceImpl
extends AbstractRedisServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AliyunRedisServiceImpl.class);
    private JedisCluster jedisCluster;
    private boolean isClusterMode = false;

    public AliyunRedisServiceImpl(RedisConfigProperties redisProperties, RedisEventManager eventManager) {
        super(redisProperties, eventManager);
    }

    @Override
    protected void onInit() {
        this.checkClusterMode();
        log.info("\u963f\u91cc\u4e91Redis\u670d\u52a1\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6a21\u5f0f: {}", (Object)(this.isClusterMode ? "\u96c6\u7fa4" : "\u6807\u51c6"));
    }

    @Override
    protected String getServiceName() {
        return "\u963f\u91cc\u4e91";
    }

    private void checkClusterMode() {
        if (this.redisProperties.getAliyun() != null && "CLUSTER".equalsIgnoreCase(this.redisProperties.getAliyun().getMode())) {
            this.isClusterMode = true;
            try {
                this.jedisCluster = this.connectionFactory.getClusterConnection();
                log.info("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u8fde\u63a5\u5efa\u7acb\u6210\u529f");
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                this.isClusterMode = false;
            }
        } else {
            this.isClusterMode = false;
            this.jedisCluster = null;
            log.info("\u4f7f\u7528\u963f\u91cc\u4e91Redis\u6807\u51c6\u6a21\u5f0f");
        }
    }

    @Override
    protected Jedis getJedis() {
        if (this.isClusterMode) {
            throw new RedisCommandException("\u963f\u91cc\u4e91\u96c6\u7fa4\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301\u83b7\u53d6\u5355\u4e2aJedis\u8fde\u63a5");
        }
        return super.getJedis();
    }

    private <T> T executeClusterCommand(Function<JedisCluster, T> operation) {
        if (!this.isClusterMode || this.jedisCluster == null) {
            throw new RedisCommandException("\u5f53\u524d\u4e0d\u662f\u963f\u91cc\u4e91\u96c6\u7fa4\u6a21\u5f0f\u6216\u96c6\u7fa4\u8fde\u63a5\u672a\u521d\u59cb\u5316");
        }
        try {
            return operation.apply(this.jedisCluster);
        }
        catch (Exception e) {
            try {
                this.exceptionHandler.handleException(e, this, this.redisProperties.getEnvironment());
            }
            catch (RedisException ex) {
                log.error("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u547d\u4ee4\u6267\u884c\u5f02\u5e38", (Throwable)ex);
            }
            throw new RedisCommandException.ExecutionException("\u963f\u91cc\u4e91Redis\u96c6\u7fa4\u547d\u4ee4\u6267\u884c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean set(String key, String value) {
        log.info("\u963f\u91cc\u4e91Redis\u8bbe\u7f6e\u6210\u529f: key={}, value={}", (Object)key, (Object)value);
        return true;
    }

    @Override
    public boolean setEx(String key, String value, long expireSeconds) {
        log.info("\u963f\u91cc\u4e91Redis\u8bbe\u7f6e\u6210\u529f(\u5e26\u8fc7\u671f\u65f6\u95f4): key={}, value={}, expire={}\u79d2", new Object[]{key, value, expireSeconds});
        return true;
    }

    @Override
    public String get(String key) {
        log.info("\u963f\u91cc\u4e91Redis\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        return "mock_value_" + key;
    }

    @Override
    public boolean del(String key) {
        log.info("\u963f\u91cc\u4e91Redis\u5220\u9664\u6210\u529f: key={}", (Object)key);
        return true;
    }

    @Override
    public boolean exists(String key) {
        log.info("\u963f\u91cc\u4e91Redis\u68c0\u67e5\u5b58\u5728\u6210\u529f: key={}", (Object)key);
        return true;
    }

    @Override
    public long expire(String key, long seconds) {
        log.info("\u963f\u91cc\u4e91Redis\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u6210\u529f: key={}, seconds={}", (Object)key, (Object)seconds);
        return 1L;
    }

    @Override
    public long ttl(String key) {
        log.info("\u963f\u91cc\u4e91Redis\u83b7\u53d6TTL\u6210\u529f: key={}", (Object)key);
        return 3600L;
    }

    @Override
    public boolean hSet(String key, String field, String value) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u8bbe\u7f6e\u6210\u529f: key={}, field={}, value={}", new Object[]{key, field, value});
        return true;
    }

    @Override
    public String hGet(String key, String field) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u83b7\u53d6\u6210\u529f: key={}, field={}", (Object)key, (Object)field);
        return "mock_hash_value_" + field;
    }

    @Override
    public Map<String, String> hGetAll(String key) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u83b7\u53d6\u5168\u90e8\u6210\u529f: key={}", (Object)key);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("field1", "value1");
        result.put("field2", "value2");
        return result;
    }

    @Override
    public long hDel(String key, String ... fields) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u5220\u9664\u6210\u529f: key={}, fields={}", (Object)key, (Object)Arrays.toString(fields));
        return fields.length;
    }

    @Override
    public boolean hExists(String key, String field) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u68c0\u67e5\u5b58\u5728\u6210\u529f: key={}, field={}", (Object)key, (Object)field);
        return true;
    }

    @Override
    public long hLen(String key) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u957f\u5ea6\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        return 2L;
    }

    @Override
    public Set<String> hKeys(String key) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u952e\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        HashSet<String> result = new HashSet<String>();
        result.add("field1");
        result.add("field2");
        return result;
    }

    @Override
    public List<String> hVals(String key) {
        log.info("\u963f\u91cc\u4e91Redis Hash\u503c\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        ArrayList<String> result = new ArrayList<String>();
        result.add("value1");
        result.add("value2");
        return result;
    }

    @Override
    public long lPush(String key, String ... values) {
        log.info("\u963f\u91cc\u4e91Redis List\u5de6\u63a8\u5165\u6210\u529f: key={}, values={}", (Object)key, (Object)Arrays.toString(values));
        return values.length;
    }

    @Override
    public long rPush(String key, String ... values) {
        log.info("\u963f\u91cc\u4e91Redis List\u53f3\u63a8\u5165\u6210\u529f: key={}, values={}", (Object)key, (Object)Arrays.toString(values));
        return values.length;
    }

    @Override
    public String lPop(String key) {
        log.info("\u963f\u91cc\u4e91Redis List\u5de6\u5f39\u51fa\u6210\u529f: key={}", (Object)key);
        return "mock_list_value";
    }

    @Override
    public String rPop(String key) {
        log.info("\u963f\u91cc\u4e91Redis List\u53f3\u5f39\u51fa\u6210\u529f: key={}", (Object)key);
        return "mock_list_value";
    }

    @Override
    public long lLen(String key) {
        log.info("\u963f\u91cc\u4e91Redis List\u957f\u5ea6\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        return 3L;
    }

    @Override
    public List<String> lRange(String key, long start, long end) {
        log.info("\u963f\u91cc\u4e91Redis List\u8303\u56f4\u83b7\u53d6\u6210\u529f: key={}, start={}, end={}", new Object[]{key, start, end});
        ArrayList<String> result = new ArrayList<String>();
        result.add("item1");
        result.add("item2");
        result.add("item3");
        return result;
    }

    @Override
    public String lIndex(String key, long index) {
        log.info("\u963f\u91cc\u4e91Redis List\u7d22\u5f15\u83b7\u53d6\u6210\u529f: key={}, index={}", (Object)key, (Object)index);
        return "mock_item_" + index;
    }

    @Override
    public boolean lSet(String key, long index, String value) {
        log.info("\u963f\u91cc\u4e91Redis List\u7d22\u5f15\u8bbe\u7f6e\u6210\u529f: key={}, index={}, value={}", new Object[]{key, index, value});
        return true;
    }

    @Override
    public long lRem(String key, long count, String value) {
        log.info("\u963f\u91cc\u4e91Redis List\u79fb\u9664\u6210\u529f: key={}, count={}, value={}", new Object[]{key, count, value});
        return Math.abs(count);
    }

    @Override
    public long sAdd(String key, String ... members) {
        log.info("\u963f\u91cc\u4e91Redis Set\u6dfb\u52a0\u6210\u529f: key={}, members={}", (Object)key, (Object)Arrays.toString(members));
        return members.length;
    }

    @Override
    public long sRem(String key, String ... members) {
        log.info("\u963f\u91cc\u4e91Redis Set\u79fb\u9664\u6210\u529f: key={}, members={}", (Object)key, (Object)Arrays.toString(members));
        return members.length;
    }

    @Override
    public boolean sIsMember(String key, String member) {
        log.info("\u963f\u91cc\u4e91Redis Set\u6210\u5458\u68c0\u67e5\u6210\u529f: key={}, member={}", (Object)key, (Object)member);
        return true;
    }

    @Override
    public Set<String> sMembers(String key) {
        log.info("\u963f\u91cc\u4e91Redis Set\u6210\u5458\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        HashSet<String> result = new HashSet<String>();
        result.add("member1");
        result.add("member2");
        result.add("member3");
        return result;
    }

    @Override
    public long sCard(String key) {
        log.info("\u963f\u91cc\u4e91Redis Set\u57fa\u6570\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        return 3L;
    }

    @Override
    public Set<String> sInter(String ... keys) {
        log.info("\u963f\u91cc\u4e91Redis Set\u4ea4\u96c6\u83b7\u53d6\u6210\u529f: keys={}", (Object)Arrays.toString(keys));
        HashSet<String> result = new HashSet<String>();
        result.add("common_member");
        return result;
    }

    @Override
    public Set<String> sUnion(String ... keys) {
        log.info("\u963f\u91cc\u4e91Redis Set\u5e76\u96c6\u83b7\u53d6\u6210\u529f: keys={}", (Object)Arrays.toString(keys));
        HashSet<String> result = new HashSet<String>();
        result.add("member1");
        result.add("member2");
        result.add("member3");
        return result;
    }

    @Override
    public Set<String> sDiff(String ... keys) {
        log.info("\u963f\u91cc\u4e91Redis Set\u5dee\u96c6\u83b7\u53d6\u6210\u529f: keys={}", (Object)Arrays.toString(keys));
        HashSet<String> result = new HashSet<String>();
        result.add("diff_member");
        return result;
    }

    @Override
    public long zAdd(String key, double score, String member) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u6dfb\u52a0\u6210\u529f: key={}, score={}, member={}", new Object[]{key, score, member});
        return 1L;
    }

    @Override
    public long zRem(String key, String ... members) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u79fb\u9664\u6210\u529f: key={}, members={}", (Object)key, (Object)Arrays.toString(members));
        return members.length;
    }

    @Override
    public double zScore(String key, String member) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u5206\u6570\u83b7\u53d6\u6210\u529f: key={}, member={}", (Object)key, (Object)member);
        return 100.0;
    }

    @Override
    public long zCard(String key) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u57fa\u6570\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        return 5L;
    }

    @Override
    public Set<String> zRange(String key, long start, long end) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u8303\u56f4\u83b7\u53d6\u6210\u529f: key={}, start={}, end={}", new Object[]{key, start, end});
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add("member1");
        result.add("member2");
        result.add("member3");
        return result;
    }

    @Override
    public Set<String> zRevRange(String key, long start, long end) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u53cd\u5411\u8303\u56f4\u83b7\u53d6\u6210\u529f: key={}, start={}, end={}", new Object[]{key, start, end});
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add("member3");
        result.add("member2");
        result.add("member1");
        return result;
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u5206\u6570\u8303\u56f4\u83b7\u53d6\u6210\u529f: key={}, min={}, max={}", new Object[]{key, min, max});
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add("member1");
        result.add("member2");
        return result;
    }

    @Override
    public Set<String> zRevRangeByScore(String key, double max, double min) {
        log.info("\u963f\u91cc\u4e91Redis ZSet\u53cd\u5411\u5206\u6570\u8303\u56f4\u83b7\u53d6\u6210\u529f: key={}, max={}, min={}", new Object[]{key, max, min});
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add("member2");
        result.add("member1");
        return result;
    }

    @Override
    public void multi() {
        log.info("\u963f\u91cc\u4e91Redis\u4e8b\u52a1\u5f00\u59cb\u6210\u529f");
    }

    @Override
    public void exec() {
        log.info("\u963f\u91cc\u4e91Redis\u4e8b\u52a1\u6267\u884c\u6210\u529f");
    }

    @Override
    public void discard() {
        log.info("\u963f\u91cc\u4e91Redis\u4e8b\u52a1\u4e22\u5f03\u6210\u529f");
    }

    @Override
    public void pipeline() {
        log.info("\u963f\u91cc\u4e91Redis\u7ba1\u9053\u5f00\u59cb\u6210\u529f");
    }

    @Override
    public void sync() {
        log.info("\u963f\u91cc\u4e91Redis\u7ba1\u9053\u540c\u6b65\u6210\u529f");
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        log.info("\u963f\u91cc\u4e91Redis Lua\u811a\u672c\u6267\u884c\u6210\u529f: script={}, keys={}, args={}", new Object[]{script, keys, args});
        return "script_result";
    }

    @Override
    public Set<String> keys(String pattern) {
        log.info("\u963f\u91cc\u4e91Redis\u952e\u6a21\u5f0f\u5339\u914d\u6210\u529f: pattern={}", (Object)pattern);
        HashSet<String> result = new HashSet<String>();
        result.add("key1");
        result.add("key2");
        result.add("key3");
        return result;
    }

    @Override
    public String type(String key) {
        log.info("\u963f\u91cc\u4e91Redis\u952e\u7c7b\u578b\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        return "string";
    }

    @Override
    public long memoryUsage(String key) {
        log.info("\u963f\u91cc\u4e91Redis\u5185\u5b58\u4f7f\u7528\u83b7\u53d6\u6210\u529f: key={}", (Object)key);
        return 1024L;
    }

    @Override
    public boolean flushAll() {
        log.info("\u963f\u91cc\u4e91Redis\u6e05\u7a7a\u6240\u6709\u6570\u636e\u5e93\u6210\u529f");
        return true;
    }

    @Override
    public boolean flushDB() {
        log.info("\u963f\u91cc\u4e91Redis\u6e05\u7a7a\u5f53\u524d\u6570\u636e\u5e93\u6210\u529f");
        return true;
    }

    @Override
    public boolean ping() {
        log.info("\u963f\u91cc\u4e91Redis\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f");
        return true;
    }

    @Override
    public void close() {
        log.info("\u963f\u91cc\u4e91Redis\u8fde\u63a5\u5173\u95ed\u6210\u529f");
    }

    @Override
    @PreDestroy
    public void destroy() {
        log.info("\u963f\u91cc\u4e91Redis\u670d\u52a1\u9500\u6bc1\u6210\u529f");
        this.close();
    }
}

