package cn.com.anysdk.sms.api;

import java.util.Map;

/**
 * SMS服务配置接口
 */
public interface ISmsConfig {
    /**
     * 获取服务提供商类型
     *
     * @return 提供商类型
     */
    String getProviderType();

    /**
     * 获取访问密钥ID
     *
     * @return 访问密钥ID
     */
    String getAccessKeyId();

    /**
     * 获取访问密钥密码
     *
     * @return 访问密钥密码
     */
    String getAccessKeySecret();

    /**
     * 获取区域
     *
     * @return 区域
     */
    String getRegion();

    /**
     * 获取签名
     *
     * @return 签名
     */
    String getSignName();

    /**
     * 获取默认模板ID
     *
     * @return 默认模板ID
     */
    String getDefaultTemplateId();


    /**
     * 获取API端点
     *
     * @return API端点URL
     */
    String getEndpoint();

    /**
     * 获取超时时间（毫秒）
     *
     * @return 超时时间
     */
    default int getTimeout() {
        return 5000;
    }

    /**
     * 是否启用SSL验证
     *
     * @return 是否启用SSL验证
     */
    default boolean isSSLVerificationEnabled() {
        return true;
    }

}
