package cn.com.anysdk.sms.api;

import java.util.List;
import java.util.Map;

/**
 * 短信服务接口，提供短信发送能力
 */
public interface ISmsService {

    /**
     * 发送单条短信
     * @param request 短信请求对象，包含手机号、模板ID、参数等
     * @return 发送结果响应
     */
    SmsResponse send(SmsRequest request);

    /**
     * 批量发送短信
     * @param requests 短信请求对象列表
     * @return 批量发送结果响应
     */
    List<SmsResponse> sendBatch(List<SmsRequest> requests);

    /**
     * 查询短信发送状态
     * @param messageId 消息ID
     * @return 查询结果响应
     */
    SmsResponse queryStatus(String messageId);

    /**
     * 发送单条短信（带扩展参数，适配不同运营商特殊参数）
     * @param request 短信请求对象
     * @param extraParams 扩展参数
     * @return 发送结果响应
     */
    default SmsResponse sendWithExtra(SmsRequest request, Map<String, Object> extraParams) {
        // 默认实现可为空，由具体实现类处理
        throw new UnsupportedOperationException("Not implemented");
    }

    /**
     * 批量查询短信发送状态
     * @param messageIds 消息ID列表
     * @return 批量查询结果响应
     */
    default List<SmsResponse> queryStatusBatch(List<String> messageIds) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /**
     * 获取短信发送配额信息
     * @return 配额信息响应
     */
    default SmsResponse getQuota() {
        throw new UnsupportedOperationException("Not implemented");
    }

    /**
     * 获取服务提供商类型
     * @return 提供商类型
     */
    String getProviderType();

    /**
     * 获取当前配置
     * @return SMS配置对象
     */
    ISmsConfig getConfig();
}
