package cn.com.anysdk.sms.api;

import com.aliyun.dysmsapi20170525.models.SendSmsRequest;

import lombok.Builder;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Map;
@Data
@Builder
public class SmsRequest  {
    /**
     * 接收短信的手机号，需符合 E.164 标准
     */
    private String phoneNumber;

    /**
     * 短信模板ID
     */
    private String templateId;

    /**
     * 可选，模板参数，key-value 形式
     */
    private Map<String, String> templateParams;

    /**
     * 可选，短信签名，若为空则使用默认签名
     */
    private String signName;

    /**
     * 可选，扩展参数，适配不同运营商特殊参数
     */
    private Map<String, Object> extraParams;
    
    /**
     * 可选，定时发送时间
     */
    private LocalDateTime scheduledTime;
    
    /**
     * 可选，短信优先级（1-10，默认为5）
     */
    private Integer priority = 5;
    
    /**
     * 可选，是否需要状态报告
     */
    private boolean needStatusReport = true;
    
    /**
     * 可选，短信内容类型（文本、语音等）
     */
    private String contentType = "text";
    
    /**
     * 可选，指定使用的运营商
     */
    private String carrier;
    
    /**
     * 可选，业务标识，用于区分不同业务场景
     */
    private String businessId;
    
    /**
     * 可选，请求追踪ID
     */
    private String requestId;

}

