package cn.com.anysdk.sms.api;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.Map;

@Data
@Accessors(chain = true)
@Builder
public class SmsResponse {
    /**
     * 是否成功
     */
    private boolean success;
    
    /**
     * 消息ID
     */
    private String messageId;
    
    /**
     * 错误码
     */
    private String errorCode;
    
    /**
     * 错误消息
     */
    private String errorMessage;
    
    /**
     * 发送时间
     */
    private LocalDateTime sendTime;
    
    /**
     * 接收时间（状态报告）
     */
    private LocalDateTime receiveTime;
    
    /**
     * 短信状态（发送中、已发送、已接收、发送失败等）
     */
    private String status;
    
    /**
     * 计费条数
     */
    private Integer segments;
    
    /**
     * 运营商响应码
     */
    private String providerCode;
    
    /**
     * 额外的响应数据
     */
    private Map<String, Object> extraData;

}