package cn.com.anysdk.sms.config;

import cn.com.anysdk.sms.api.ISmsConfig;
import com.aliyun.dysmsapi20170525.Client;
import lombok.Builder;
import lombok.Data;
import com.aliyun.teaopenapi.models.Config;


@Data
@Builder
public class AliyunSmsConfig implements ISmsConfig {
    private String accessKeyId;
    private String accessKeySecret;
    private String region;
    private String signName;
    private String defaultTemplateId;
    private String endpoint;

    public Client createClient() throws Exception {
        Config config = new Config()
                .setAccessKeyId(accessKeyId)
                .setAccessKeySecret(accessKeySecret)
                .setEndpoint(endpoint)
                .setRegionId(region);
        return new Client(config);
    }


    @Override
    public String getProviderType() {
        return "aliyun";
    }

    @Override
    public String getAccessKeyId() {
        return accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    @Override
    public String getRegion() {
        return region;
    }

    @Override
    public String getSignName() {
        return signName;
    }

    @Override
    public String getDefaultTemplateId() {
        return defaultTemplateId;
    }

    @Override
    public String getEndpoint() {
        return endpoint;
    }
}
