package cn.com.anysdk.sms.config;

import cn.com.anysdk.sms.api.ISmsConfig;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 模拟短信服务配置类
 */
@Data
public class MockSmsConfig implements ISmsConfig {

    private String providerType = "MOCK";
    private String accessKeyId = "mock-access-key-id";
    private String accessKeySecret = "mock-access-key-secret";
    private String region = "mock-region";
    private String signName = "MockSMS";
    private String defaultTemplateId = "MOCK_TEMPLATE_001";
    private String endpoint = "http://mock-sms-service.example.com";
    private int timeout = 5000;
    private boolean sslVerificationEnabled = false;

    // 模拟配置的额外参数
    private Map<String, Object> extraParams = new HashMap<>();

    // 模拟成功率 (0-100)
    private int successRate = 100;

    // 模拟延迟 (毫秒)
    private int simulatedDelay = 0;

    @Override
    public String getProviderType() {
        return providerType;
    }

    @Override
    public String getAccessKeyId() {
        return accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    @Override
    public String getRegion() {
        return region;
    }

    @Override
    public String getSignName() {
        return signName;
    }

    @Override
    public String getDefaultTemplateId() {
        return defaultTemplateId;
    }

    @Override
    public String getEndpoint() {
        return endpoint;
    }

    @Override
    public int getTimeout() {
        return timeout;
    }

    @Override
    public boolean isSSLVerificationEnabled() {
        return sslVerificationEnabled;
    }
}