package cn.com.anysdk.sms.factory;

import cn.com.anysdk.sms.api.ISmsConfig;
import cn.com.anysdk.sms.api.ISmsService;
import cn.com.anysdk.sms.config.AliyunSmsConfig;
import cn.com.anysdk.sms.config.MockSmsConfig;
import cn.com.anysdk.sms.exception.SmsException;
import cn.com.anysdk.sms.impl.AliyunSmsService;
import cn.com.anysdk.sms.impl.MockSmsService;
import lombok.extern.slf4j.Slf4j;



 /**
 * SMS服务工厂
 * 用于创建不同类型的SMS服务实例
 */

@Slf4j
public class SmsServiceFactory {

    public static ISmsService createService(ISmsConfig config) {
        if (config == null) {
            log.error("SMS config is null. Cannot create service.");
            throw new SmsException("SMS config cannot be null");
        }

        String provider = config.getProviderType();
        log.info("Creating SMS service for provider: {}", provider);

        try {
            return switch (provider.toLowerCase()) {
                case "aliyun" -> {
                    log.info("Initializing Aliyun SMS service.");
                    yield new AliyunSmsService((AliyunSmsConfig) config);
                }
                case "mock" -> {
                    log.info("Initializing Mock SMS service.");
                    yield new MockSmsService((MockSmsConfig) config);
                }
                default -> {
                    log.error("Unsupported SMS provider: {}", provider);
                    throw new SmsException("Unsupported SMS provider: " + provider);
                }
            };
        } catch (Exception e) {
            log.error("Failed to create SMS service for provider: {}", provider, e);
            throw new SmsException("Failed to create SMS service: " + e.getMessage(), e);
        }

}

}
