package cn.com.anysdk.sms.monitor;

import lombok.Data;
import lombok.Builder;

import java.time.LocalDateTime;

/**
 * SMS操作上下文，记录每次操作的详细信息
 */
@Data
@Builder
public class SmsOperationContext {
    /**
     * 操作类型（发送、查询等）
     */
    private String operationType;

    /**
     * 服务提供商（阿里云、腾讯云等）
     */
    private String provider;

    /**
     * 请求ID
     */
    private String requestId;

    /**
     * 手机号
     */
    private String phoneNumber;

    /**
     * 模板ID
     */
    private String templateId;

    /**
     * 操作开始时间
     */
    private LocalDateTime startTime;

    /**
     * 操作结束时间
     */
    private LocalDateTime endTime;

    /**
     * 操作耗时（毫秒）
     */
    private long duration;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 错误消息
     */
    private String errorMessage;

    /**
     * 短信长度
     */
    private Integer messageLength;

    /**
     * 计费条数
     */
    private Integer segments;

    /**
     * 额外信息
     */
    private String extraInfo;
} 